/*
 * @(#)ErrorException.java 1.0 06/08/25
 */

// ************************************************************************
// * Copyright (c) 2006 by the Association for Computing Machinery *
// * *
// * The Java Task Force seeks to impose few restrictions on the use of *
// * these packages so that users have as much freedom as possible to *
// * use this software in constructive ways and can make the benefits of *
// * that work available to others. In view of the legal complexities *
// * of software development, however, it is essential for the ACM to *
// * maintain its copyright to guard against attempts by others to *
// * claim ownership rights. The full text of the JTF Software License *
// * is available at the following URL: *
// * *
// * http://www.acm.org/jtf/jtf-software-license.pdf *
// * *
// ************************************************************************
/**
 * This class was extracted from the ACM JTF acm.util package
 * (http://jtf.acm.org/). Modified to work with the FANG engine in the interest
 * of eliminating the main() function declaration in student applications
 */
package fang2.util;

/* Class: ErrorException */
/**
 * This class allows errors to be reported in a consistent way. Clients
 * typically call
 * 
 * <p>
 * <code>
 * &nbsp;&nbsp;&nbsp;throw new ErrorException(msg);
 * <p></code>
 * 
 * <p>
 * Because <code>ErrorException</code> is a subclass of
 * <code>RuntimeException</code>, this exception need not be declared in
 * <code>throws</code> clauses.
 */

public class ErrorException extends RuntimeException {
  private static final long serialVersionUID = -2252001211641086661L; // Generated

  /* Constructor: ErrorException(msg) */
  /**
   * Creates an <code>ErrorException</code> with the specified message.
   * 
   * @param msg
   *          The error message to be reported
   */
  public ErrorException(String msg) {
    super(msg);
  }

  /* Constructor: ErrorException(ex) */
  /**
   * Creates an <code>ErrorException</code> using an existing exception.
   * 
   * @param ex
   *          The exception to be reported
   */
  public ErrorException(Exception ex) {
    super(ex.getClass().getName() + ": " + ex.getMessage());
  }
}
