package fang2.ui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;

/**
 * WindowPositioning - utility functions for positioning windows
 * relative to other windows. Modified slightly from the WordHoard
 * version of same (all comments added to decompiled source). This type
 * provides static helper functions. It CANNOT be instantiated (private
 * constructor which throws an exception).
 *
 * @author  WordHoard at http://wordhoard.northwestern.edu
 * @author  adapted for use by blad
 */
public class WindowPositioning {
  public static void centerWindowOverWindow(Window window1,
    Window window2, int offset) {
    Dimension window2Size;
    Point window2Location;
    int y;
    Dimension screenSize = window1.getToolkit().getScreenSize();
    Dimension window1Size = window1.getSize();

    if (window2 == null) {
      window2Size = screenSize;
      window2Location = new Point(0, 0);
      y = (screenSize.height - window1Size.height) / 2;
    } else {
      window2Size = window2.getSize();
      window2Location = window2.getLocation();
      y = window2Location.y + offset;
    }
    Point window1Location = new Point(window2Location.x +
        ((window2Size.width - window1Size.width) / 2), y);

    if (window1Location.x <= 0) {
      window1Location.x = 5;
    } else if ((window1Location.x + window1Size.width) >=
        screenSize.width) {
      window1Location.x = (screenSize.width - window1Size.width - 5);
    }

    if ((window1Location.y + window1Size.height) >=
        (screenSize.height - 50)) {
      window1Location.y = (screenSize.height - window1Size.height - 50 -
          5);
    }
    window1.setLocation(window1Location);
  }

  public static void staggerWindowOverWindow(Window window1,
    Window window2, int offset) {
    Dimension screenSize = window1.getToolkit().getScreenSize();
    Dimension windowSize = window1.getSize();
    Point location = new Point(0, 0);
    if (window2 == null) {
      location.x = 10;
      location.y = 30;
    } else {
      location = window2.getLocation();
      location.x += offset;
      location.y += offset;
      if (((location.x + windowSize.width) >= screenSize.width) ||
          ((location.y + windowSize.height) >=
            (screenSize.height - 50))) {
        location.x = 10;
        location.y = 30;
      }
    }
    window1.setLocation(location);
  }

  public static void zoom(Window window, Dimension d) {
    Dimension size = window.getToolkit().getScreenSize();
    window.setLocation(new Point(10, 30));
    size.width -= 20;
    size.height -= 80;
    size.width = Math.min(size.width, d.width);
    size.height = Math.min(size.height, d.height);
    window.setSize(size);
  }

  public static void trim(JFrame window) {
    Dimension screenSize = window.getToolkit().getScreenSize();
    screenSize.width -= 20;
    screenSize.height -= 120;
    JComponent contentPane = (JComponent) window.getContentPane();
    Dimension d = contentPane.getPreferredSize();
    d.width = Math.min(d.width, screenSize.width);
    d.height = Math.min(d.height, screenSize.height);
    contentPane.setPreferredSize(d);
  }

  public static boolean tooBig(JFrame window) {
    Dimension d = window.getSize();
    return ((d.width > 780) || (d.height > 560));
  }

  private WindowPositioning() {
    throw new UnsupportedOperationException();
  }
}