package fang2.ui;

import fang2.core.*;
import fang2.sprites.*;

/**
 * This Game is for getting the players to enter their names. Once all
 * names have been entered, the game finishes.
 *
 * @author  Jam Jenkins
 */
@SuppressWarnings("serial")
public class PlayerNameInput
  extends Game {
  /** the box where the player can enter the name */
  private InputStringField[] box;

  /** the message about how many are left */
  private StringSprite status;

  /** the names of all those who have entered a new name */
  private StringSprite names;

  /** the number of names left to get */
  private int namesLeft;

  /**
   * sets up the sprites on the screen
   */
  @Override
  public void setup() {
    for (int i = 0; i < getNumberOfPlayers(); i++) {
      if (!getPlayerName(i).equals(Player.getDefaultName(i))) {
        namesLeft = 0;
        finishGame();
        return;
      }
    }
    namesLeft = getNumberOfPlayers();
    status = new StringSprite("Waiting for ALL other players.");
    status.setWidth(0.9);
    status.setLineHeight(0.05);
    status.bottomJustify();
    status.leftJustify();
    status.setLocation(0.05, 0.95);
    addSprite(status);

    names = new StringSprite();
    names.setWidth(0.9);
    names.setLineHeight(0.05);
    names.topJustify();
    names.leftJustify();
    names.setLocation(0.05, 0.3);
    addSprite(names);
    box = new InputStringField[getNumberOfPlayers()];
    for (int i = 0; i < box.length; i++) {
      // enable only player i to input
      box[i] = new InputStringField(0.9, 0.1, i);
      box[i].setLocation(0.5, 0.2);
      box[i].setLabelText("Type your name here and press Enter");
      // must be on the screen to capture input
      addSprite(box[i]);
      // hide all but the current player's box
      box[i].setVisible(i == getPlayerID());
    }
    updatePlayerNames();
  }

  /**
   * updates the names and status field when players press enter
   */
  private void updatePlayerNames() {
    String joined = "";
    namesLeft = getNumberOfPlayers();
    for (int i = 0; i < box.length; i++) {
      if (box[i].hasEnteredText()) {
        setPlayerName(box[i].getEnteredText(), i);
        joined += "Player " + i + ": " + box[i].getEnteredText() + "\n";
        namesLeft--;
      } else {
        joined += "Player " + i + ": unknown\n";
      }
    }
    names.setText(joined);
    names.setWidth(0.9);
    if (names.getHeight() > 0.5) {
      names.setHeight(0.5);
    }
    if (namesLeft > 0) {
      status.setText("Waiting for " + namesLeft + " other players.");
    } else {
      status.setText("All players named, starting game...");
      schedule(new StartRealGame(), 1);
    }
  }

  /**
   * finishes the current game so that the next game on the list can
   * begin
   *
   * @author  Jam Jenkins
   */
  class StartRealGame
    extends AlarmAdapter {
    @Override
    public void act() {
      finishGame();
    }
  }

  /**
   * keeps getting names until they are all gotten
   */
  @Override
  public void advance() {
    if (namesLeft > 0) {
      updatePlayerNames();
    }
  }
}
