package fang2.ui;

import javax.swing.*;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;


import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URL;

/**
 * Displays an html file in
 * a JDialog box.
 * @author Jam Jenkins
 */
public class HTMLDisplay
            extends JDialog implements ActionListener
{
    /**
     * used for serialization versioning
     */
    private static final long serialVersionUID = 1L;

    /**the stylesheet used to display the html*/
    private static final URL STYLE_SHEET =
        HTMLDisplay.class.getResource("resources/stylesheet.css");

    /** where the html is displayed */
    private JTextPane message;

    /** the name of the html file with respect to this directory */
    private URL filename;

    /** default size of the window */
    private static final Dimension DEFAULT_SIZE = new Dimension(300, 300);

    /** close button */
    private FunButton closeButton;

    /**
     * makes the window, but does not set it visible
     * 
     * @param title
     *            name in the title bar of the window
     * @param filename
     *            the URL to load.  URL is necessary instead
     *            of String filename because this could be
     *            loaded in applets.
     */
    public HTMLDisplay(String title, URL filename)
    {
        super();
        setTitle(title);
        this.filename = filename;
        makeComponents();
        makeLayout();
        setSize(DEFAULT_SIZE);
    }

    /**makes this gui invisible
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e)
    {
        setVisible(false);
    }

    /**sets the stylesheet used to display
     * this html
     * @param styleURL the location of the
     * stylesheet to use
     */
    public void setStyleSheet(URL styleURL)
    {
        HTMLEditorKit kit = (HTMLEditorKit)message.getEditorKit();
        StyleSheet style = new StyleSheet();
        style.importStyleSheet(styleURL);
        kit.setStyleSheet(style);
        message.setEditorKit(kit);
        try
        {
            java.util.Scanner scanner=new java.util.Scanner(filename.openStream());
            String text=scanner.findWithinHorizon("[\\s\\S]*", 0);
            message.setPage(text);
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }
        message.setEditable(false);
    }

    /** make the message pane and set its contents */
    private void makeComponents()
    {
        message = new JTextPane();
        closeButton = new FunButton("Close Help Window", DEFAULT_SIZE);
        closeButton.addActionListener(this);
        try
        {
            HTMLEditorKit kit = new HTMLEditorKit();
            StyleSheet style = new StyleSheet();
            style.importStyleSheet(STYLE_SHEET);
            kit.setStyleSheet(style);
            message.setEditorKit(kit);
            /*java.net.URLConnection connection=filename.openConnection();
            connection.setUseCaches(false);
            java.util.Scanner scanner=new java.util.Scanner(connection.getInputStream());
            String text=scanner.findWithinHorizon("[\\s\\S]*", 0);
            message.setText(text);*/
            //message.read(connection.getInputStream(), new javax.swing.text.html.HTMLDocument());

            //message.setPage(filename);
            message.setEditable(false);
            //setContent("Help", filename);
        }
        catch (Exception e)
        {
            System.err.println("Is " + filename
                               + " in the html directory above tipgame?");
            e.printStackTrace();
        }
    }

    /** place the message pane in the window */
    private void makeLayout()
    {
        FunPanel panel = new FunPanel();
        panel.setLayout(new BorderLayout());
        panel.add(new JScrollPane(message), BorderLayout.CENTER);
        panel.add(closeButton, BorderLayout.SOUTH);
        setContentPane(panel);
    }

    /**sets the content of the window displaying
     * the help screen
     * @param title the title of the JDialog box
     * @param content the content of the help
     */
    public void setContent(String title, URL content)
    {
        setTitle(title);
        try
        {
            String text = "";
            BufferedReader reader = new BufferedReader(
                                        new InputStreamReader(content.openStream()));
            while (reader.ready())
                text += reader.readLine() + "<br>";
            message.setText(text);
        }
        catch (Exception e)
        {
           StringWriter string=new StringWriter();
           PrintWriter writer=new PrintWriter(string);
           e.printStackTrace(writer);
           try
           {
              message.setText("Tried to load "+title+
                 ", but a problem occurred:\n" +
                 "<pre>"+string.toString()+"</pre>");
           }
           catch(Throwable t){}
        }
    }

    public void setText(String helpText)
    {
        message.setText(helpText);
    }
}
