package fang2.ui;

import javax.swing.JPanel;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

@SuppressWarnings("serial")
public class DialogPanel
  extends JPanel {
  protected JPanel body = new JPanel();
  protected JPanel buttons = new JPanel();
  protected int numButtons = 0;

  public DialogPanel() {
    this.body.setLayout(new BoxLayout(this.body, 1));
    this.buttons.setLayout(new BoxLayout(this.buttons, 0));
    this.buttons.add(Box.createHorizontalGlue());
    this.buttons.setBorder(BorderFactory.createEmptyBorder(10, 0, 0,
        0));
    setLayout(new BorderLayout());
    super.add(this.body, "Center");
    super.add(this.buttons, "South");
    setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
  }

  public void add(int spacing) {
    this.body.add(Box.createVerticalStrut(spacing));
  }

  public void add(JComponent component, int spacing) {
    if (spacing > 0) {
      this.body.add(Box.createVerticalStrut(spacing));
    }
    component.setAlignmentX(0.0F);
    this.body.add(component);
  }

  public void add(JComponent component) {
    add(component, 0);
  }

  public void add(String str, int spacing) {
    add(new JLabel(str), spacing);
  }

  public void add(String str) {
    add(str, 0);
  }

  public JButton addButton(String label,
    ActionListener actionListener) {
    if (this.numButtons > 0) {
      this.buttons.add(Box.createHorizontalStrut(10));
    }
    JButton button = new JButton(label);
    this.buttons.add(button);
    button.addActionListener(actionListener);
    this.numButtons += 1;
    return button;
  }

  public JButton addDefaultButton(String label,
    ActionListener actionListener) {
    JButton button = addButton(label, actionListener);
    getRootPane().setDefaultButton(button);
    return button;
  }

  public JButton addSmallButton(String label,
    ActionListener actionListener) {
    if (this.numButtons > 0) {
      this.buttons.add(Box.createHorizontalStrut(10));
    }
    JButton button = new JButton(label);
    Font font = button.getFont();
    button.setFont(new Font(font.getName(), font.getStyle(),
        font.getSize() - 2));

    this.buttons.add(button);
    button.addActionListener(actionListener);
    this.numButtons += 1;
    return button;
  }

  public JPanel getBody() {
    return this.body;
  }

  public JPanel getButtons() {
    return this.buttons;
  }
}