package fang2.transformers;

import fang2.core.Sprite;
import fang2.core.TransformerAdapter;

/**
 * A transformer which wraps the sprite around the screen. The left edge
 * is connected to the right edge and the top to the bottom. This is a
 * simple torus mapping of the screen.
 */
public class WrapTransformer
  extends TransformerAdapter {
  /**
   * Wrap the sprite around the edges; make the screen behave as if it
   * were a torus.
   *
   * <p>If center of sprite is more than half of its width past the left
   * edge, wrap it to half-width off the right edge and vice versa. If
   * the center of the sprite is more than half of its height past the
   * top edge, wrap it to half-height off the bottom edge and vice
   * versa.
   *
   * @param  sprite  the {@link Sprite} to wrap.
   */
  @Override
  public void updateSprite(Sprite sprite) {
    double halfWidth = sprite.getWidth() / 2;

    if (sprite.getX() < -halfWidth) {// off screen to left
      sprite.setX(1.0 + halfWidth);// wrap
    } else if (sprite.getX() > (1.0 + halfWidth)) {
      sprite.setX(-halfWidth);
    }

    double halfHeight = sprite.getHeight();
    if (sprite.getY() < -halfHeight) {
      sprite.setY(1.0 + halfHeight);
    } else if (sprite.getY() > (1.0 + halfHeight)) {
      sprite.setY(-halfHeight);
    }
  }
}
