package fang2.transformers;

import fang2.core.Game;
import fang2.core.Sprite;
import fang2.core.TransformerAdapter;

public class TimeLimitedTransformer
  extends TransformerAdapter {
  /**
   * the time remaining for this transformer; sprite will be eliminated
   * when crosses 0.0
   */
  double secondsToLive;

  /**
   * Construct a new {@link TimeLimitedTransformer}. Linked to the
   * given sprite and lasting the given amount of time.
   *
   * @param  controlled     sprite to eliminate after the given time
   * @param  secondsToLive  time to live for the sprite
   */
  public TimeLimitedTransformer(
    double secondsToLive) {
    this.secondsToLive = secondsToLive;
  }

  /**
   * Get remaining seconds to live.
   *
   * @return  the secondsToLive
   */
  public double getSecondsToLive() {
    return secondsToLive;
  }

  /**
   * Set the remaining seconds to live to the given value
   *
   * @param  secondsToLive  the secondsToLive to set
   */
  public void setSecondsToLive(double secondsToLive) {
    this.secondsToLive = secondsToLive;
  }

  /**
   * Add the given number of seconds to the time to live value
   *
   * @param  deltaSecondsToLive  seconds to add
   */
  public void addSecondsToLive(double deltaSecondsToLive) {
    secondsToLive += deltaSecondsToLive;
  }

  /**
   * Subtract the given number of seconds from the time to live value
   *
   * @param  deltaSecondsToLive  seconds to subtract
   */
  public void subtractSecondsToLive(double deltaSecondsToLive) {
    addSecondsToLive(-deltaSecondsToLive);
  }

  /**
   * Update to another frame by counting down. The elapsed time since
   * the last frame is subtracted from seconds to live and if seconds to
   * live crosses 0.0 the sprite we control goes off the screen.
   */
  @Override
  public void advance(double dT) {
    secondsToLive -= dT;
    super.advance(dT);
  }
  
  /**
   * removes the sprite from the screen when the time elapses
   */
  public void updateSprite(Sprite controlled)
  {
    if (secondsToLive <= 0.0) {
      controlled.removeFromCanvas();
    }	  
  }
}

//Uploaded on Wed Sep 23 07:18:56 EDT 2009

