package fang2.transformers;

import fang2.attributes.Vector2D;
import fang2.core.Sprite;

public class SpeedAheadTransformer
  extends VelocityTransformer {
  /** the speed in screens/second */
  private double speed;

  /** amount of screens we just went */
  private double forward;
  
  /**
   * Construct a new {@link SpeedAheadTransformer} with the given
   * velocity.
   *
   * @param  speed   the speed (screens/second) that the sprite moves
   *                 ahead (in its facing direction)
   */
  public SpeedAheadTransformer(double speed) {
    super(new Vector2D());// dummy for constructor
    this.speed = speed;
  }

  /**
   * Advance this transformer one frame. Get the facing vector from the
   * underlying sprite and then use the speed and the elapsed time to
   * scale it. Update the location. This just does speed, not
   * acceleration.
   *
   * @param  dT  elapsed time since last call to advance
   */
  @Override
  public void advance(double dT) {
    forward = speed * dT;
    super.advance(dT);
  }

  /**
   * Get the speed, the amount of movement in the facing direction.
   *
   * @return  the speed
   */
  public double getSpeed() {
    return speed;
  }

  /**
   * Set the speed of the object.
   *
   * @param  speed  the new speed
   */
  public void setSpeed(double speed) {
    this.speed = Math.min(getMaximumMagnitude(), Math.max(speed, getMinimumMagnitude()));
    
  }
  
  /**
   * Actually update the sprite (by moving it forward).
   */
  @Override
  public void updateSprite(Sprite sprite) {
      sprite.forward(forward);
  }
}
