package fang2.transformers;

import fang2.core.Game;
import fang2.core.Sprite;
import fang2.core.TransformerAdapter;

public class ShooterTransformer
  extends TransformerAdapter {
  /** has the transformer been ordered to shoot? */
  private boolean shootIfPossible;

  /**
   * Construct a new {@link ShooterTransformer}: a transformer which,
   * whenever a bullet is produced, sends the bullet off.
   */
  public ShooterTransformer() {
    this.shootIfPossible = false;
  }


  @Override
  public void updateSprite(Sprite controlled) {
    if (!(controlled instanceof Shooter) || !shootIfPossible) {
      return;
    }
    Shooter sh_controlled = (Shooter)controlled;
    Sprite bullet = sh_controlled.getProjectile();
    if (bullet != null) {
      Game.getCurrentGame().addSprite(bullet);
    }
  }

  @Override
  public void nonMaskableAdvance(double dT) {
    shootIfPossible = false;
  }
  
  /**
   * Advance one frame: Ask the shooter for a projectile; if they gave
   * us one, initialize all the positioning and movement information and
   * set it loose.
   */
  @Override
  public void advance(double dT) {
    shootIfPossible = true;    
  }
}
