package fang2.transformers;

import fang2.core.Sprite;

public class ScaleTransformer
  extends InterpolatorTransformer {

  /** the initial scale value */
  private final double startScale;
  /** the final scale value */
  private final double endScale;
  /** the current scale value */
  private double currScale;
  
  public ScaleTransformer(double transitionTime, boolean enabled, double startScale, double endScale) {
    super(transitionTime, enabled);
    this.startScale = startScale;
    this.endScale = endScale;
  }

  public ScaleTransformer(double transitionTime, double startScale, double endScale) {
    this(transitionTime, true, startScale, endScale);
  }
  
  /**
   * Generate the current scale given the persentage completed so far.
   */
  @Override
  protected void interpolate(double interpolated) {
    currScale = (1.0 - interpolated) * startScale + interpolated * endScale;
  }

  /**
   * Apply the new scale to the given sprite.
   */
  @Override
  public void updateSprite(Sprite sprite) {
    sprite.setScale(currScale);
  }

}
