package fang2.transformers;

import fang2.attributes.Vector2D;
import fang2.core.GameRedirection;
import fang2.core.Sprite;

public class RepelTransformer
  extends VelocityTransformer {
  private double maxDistance;
  private Sprite source;

  public RepelTransformer() {
    super();
    maxDistance = Double.POSITIVE_INFINITY;
    // TODO Auto-generated constructor stub
  }

  public RepelTransformer(double magnitude) {
    super(0, magnitude);
    maxDistance = Double.POSITIVE_INFINITY;
    // TODO Auto-generated constructor stub
  }

  public Sprite getTarget() {
    return source;
  }

  public void setMaxDistance(double max) {
    maxDistance = max;
  }

  public void setTarget(Sprite target) {
    this.source = target;
  }

  @Override
  public void updateSprite(Sprite sprite) {
    Vector2D vector = new Vector2D(source.getLocation(),
        sprite.getLocation());
    if (vector.getMagnitude() == 0) {
      vector = new Vector2D(GameRedirection.getCurrentGame()
          .randomDouble(0, 360), 0.001);
    }
    if (vector.getMagnitude() > maxDistance) {
      // do nothing, already too far away
    } else if ((vector.getMagnitude() + getLocation().getMagintude()) >
        maxDistance) {
      vector.setMagnitude(maxDistance - vector.getMagnitude());
      setLocation(vector);
      super.updateSprite(sprite);
    } else {
      vector.setMagnitude(getVelocity().getMagnitude());
      setVelocity(vector);
      super.updateSprite(sprite);
    }
  }
}
