package fang2.transformers;

import fang2.attributes.Location2D;
import fang2.core.Game;
import fang2.core.TransformerAdapter;

import java.util.ArrayList;

public class MouseMovementTransformer
  extends TransformerAdapter {
  private final int playerId;
  private final ArrayList<MouseMovementTransformerListener> listeners;

  public MouseMovementTransformer(int playerId) {
    this.playerId = playerId;
    listeners = new ArrayList<MouseMovementTransformerListener>();
  }

  public MouseMovementTransformer() {
    this(0);
  }
  
  public void add(MouseMovementTransformerListener mmtl) {
    listeners.add(mmtl);
    mmtl.addTransformer(this);
  }
  
  public void remove(MouseMovementTransformerListener mmtl) {
    listeners.remove(mmtl);
    mmtl.removeTransformer(this);
  }
  
  @Override
  public void advance(double dT) {
    Location2D mouseLocation = Game.getCurrentGame().getMouse2D(playerId);
    for (MouseMovementTransformerListener mmtl : listeners) {
      mmtl.mouseMovedTo(mouseLocation);
    }
  }
}
