package fang2.transformers;

import fang2.attributes.Location2D;
import fang2.core.Game;
import fang2.core.TransformerAdapter;

import java.util.ArrayList;

public class MouseClickTransformer
  extends TransformerAdapter {
  private final int playerId;
  private final ArrayList<MouseClickTransformerListener> listeners;

  public MouseClickTransformer(int playerId) {
    this.playerId = playerId;
    listeners = new ArrayList<MouseClickTransformerListener>();
  }

  public MouseClickTransformer() {
    this(0);
  }

  public void add(MouseClickTransformerListener mctl) {
    listeners.add(mctl);
    mctl.addTransformer(this);
  }

  public void remove(MouseClickTransformerListener mctl) {
    listeners.remove(mctl);
    mctl.removeTransformer(this);
  }

  @Override
  public void advance(double dT) {
    Location2D mouseLocation = Game.getCurrentGame().getLeftClick2D(
        playerId);
    if (mouseLocation != null) {
      for (MouseClickTransformerListener mctl : listeners) {
        mctl.mouseClickedAt(mouseLocation, 1);
      }
    }
    mouseLocation = Game.getCurrentGame().getMiddleClick2D(playerId);
    if (mouseLocation != null) {
      for (MouseClickTransformerListener mctl : listeners) {
        mctl.mouseClickedAt(mouseLocation, 2);
      }
    }
    mouseLocation = Game.getCurrentGame().getRightClick2D(playerId);
    if (mouseLocation != null) {
      for (MouseClickTransformerListener mctl : listeners) {
        mctl.mouseClickedAt(mouseLocation, 3);
      }
    }
  }
}
