package fang2.transformers;

import java.util.ArrayList;
import java.util.List;

import fang2.core.Sprite;
import fang2.core.TransformerAdapter;

public class HitSpriteTransformer
  extends TransformerAdapter {
  /** the list of explicit targets to be tested */
  private final List<Sprite> targets;

  /**
   * Create a new {@link HitSpriteTransformer} with an empty target set.
   */
  public HitSpriteTransformer() {
    this.targets = new ArrayList<Sprite>();
  }

  /**
   * Create a new {@link HitSpriteTransformer} with the given source and
   * target nodes. The controlled field is the sprite which does the
   * hitting. This is for the common case where there is just one
   * target; rather than having to construct and call add, this does it
   * all in one step.
   *
   * @param  target      the target {@link Sprite}
   */
  public HitSpriteTransformer(Sprite target) {
    this();
    add(target);
  }

  /**
   * Add a target to the list of targets.
   *
   * @param  target  the sprite to add
   */
  public void add(Sprite target) {
    if ((target != null) && (targets.indexOf(target) < 0)) {
      targets.add(target);
    }
  }

  /**
   * Access the whole list of targets
   *
   * @return  the list of targets
   */
  public List<Sprite> getTargets() {
    return targets;
  }

  /**
   * Remove a target from the list of targets
   *
   * @param  target  the target to remove
   */
  public void remove(Sprite target) {
    targets.remove(target);
  }

  /**
   * Advance one frame; check for "impact".
   */
  @Override
  public void updateSprite(Sprite controlled) {
    if (controlled == null) {
      return;
    }
    for (Sprite t : targets) {
      if ((t != controlled) && controlled.intersects(t)) {
        if (((HitTarget) controlled).react(t)) {
          break;
        }
      }
    }
  }
}
