package fang2.transformers;

import java.util.ArrayList;
import java.util.List;

import fang2.core.Game;
import fang2.core.Sprite;

public class HitClassTransformer
  extends HitSpriteTransformer {
  private final List<Class<? extends Sprite>> targetClasses; 
  public HitClassTransformer(Sprite controlled) {
    super(controlled);
    targetClasses = new ArrayList<Class<? extends Sprite>>();
  }
  public HitClassTransformer(Sprite controlled, Class<? extends Sprite> targetClass) {
    this(controlled);
    targetClasses.add(targetClass);
  }
  public void add(Class<? extends Sprite> targetClass) {
    if (targetClasses.indexOf(targetClass) < 0)
      targetClasses.add(targetClass);
  }
  public void remove(Class<? extends Sprite> targetClass) {
    targetClasses.remove(targetClass);
  }
  
  private void collectUpSprites() {
    List<Sprite> targets = getTargets();
    targets.clear();
    
    Game game = Game.getCurrentGame();
    for (Sprite sprite : game.getCanvas().getAllSprites()) {
      for (Class<? extends Sprite> currClass : targetClasses) {
        if (currClass.isInstance(sprite)) {
          targets.add(sprite);
          break;
        }
      }
    }
  }
  
  @Override
  public void advance(double dT) {
    collectUpSprites();
    super.advance(dT);
  }
}
