package fang2.transformers;

import fang2.attributes.Vector2D;
import fang2.core.Sprite;

public class AttractTransformer
  extends VelocityTransformer {
  private double minDistance;
  private Sprite target;

  public AttractTransformer() {
    super();
    // TODO Auto-generated constructor stub
  }

  public AttractTransformer(double magnitude) {
    super(0, magnitude);
    // TODO Auto-generated constructor stub
  }

  public Sprite getTarget() {
    return target;
  }

  public void setMinDistance(double min) {
    minDistance = min;
  }

  public void setTarget(Sprite target) {
    this.target = target;
  }

  @Override
  public void updateSprite(Sprite sprite) {
    Vector2D vector = new Vector2D(sprite.getLocation(),
        target.getLocation());
    if ((vector.getMagnitude() - getLocation().getMagintude()) <
        minDistance) {
      vector.setMagnitude(vector.getMagnitude() - minDistance);
      setLocation(vector);
      super.updateSprite(sprite);
    } else if (vector.getMagnitude() < getLocation().getMagintude()) {
      super.updateSprite(sprite);
      sprite.setLocation(target.getLocation());
    } else {
      vector.setMagnitude(getVelocity().getMagnitude());
      setVelocity(vector);
      super.updateSprite(sprite);
    }
  }
}
