package fang2.transformers;

import fang2.attributes.Vector2D;
import fang2.core.Sprite;

public class AccelerationAheadTransformer
  extends VelocityTransformer {
  /** the speedup in screens/second^2 */
  private double speedup;

  /** the dT of the last frame time */
  private double dT;
  
  /**
   * Construct a new {@link AccelerationAheadTransformer} with the given
   * velocity.
   *
   * @param  speedup   the speed (screens/second) that the sprite moves
   *                 ahead (in its facing direction)
   */
  public AccelerationAheadTransformer(double speedup) {
    super(new Vector2D()); // dummy value
    this.speedup = speedup;
  }

  /**
   * Advance this transformer one frame. Get the facing vector from the
   * underlying sprite and then use the speed and the elapsed time to
   * scale it. Update the location. This just does speed, not
   * acceleration.
   *
   * @param  dT  elapsed time since last call to advance
   */
  @Override
  public void advance(double dT) {
    this.dT = dT;
    super.advance(dT);
  }

  
  
  /* (non-Javadoc)
   * @see fang2.core.TransformerAdapter#updateSprite(fang2.core.Sprite)
   */
  @Override
  public void updateSprite(Sprite sprite) {
    Vector2D heading = sprite.getFacingVector().normalize();
    setVelocity(getVelocity().add(heading.multiply(dT * speedup)));
    super.updateSprite(sprite);
  }

  /**
   * Get the speed, the amount of movement in the facing direction.
   *
   * @return  the speed
   */
  public double getSpeedup() {
    return speedup;
  }

  /**
   * Set the speed of the object.
   *
   * @param  speed  the new speed
   */
  public void setSpeedup(double speed) {
    this.speedup = speed;
  }
}
