package fang2.sprites;

import java.awt.geom.Rectangle2D;

import fang2.core.Sprite;

/**
 * This class represents a rectangular sprite.
 * @author Jam Jenkins
 */
public class RectangleSprite extends Sprite
{
    /**
     * makes a rectangular sprite.  The magnitude of
     * the width and height only matter with respect
     * to each other.  For example, a RectangleSprite
     * constructed with a width
     * 2 and height 1 is the same as making the
     * width 20 and the height 10 because they both
     * have the same height/width aspect ratio of 2.
     * @param width the horizontal span
     * @param height the vertical span
     */
    public RectangleSprite(double width, double height)
    {
        super(new Rectangle2D.Double(0, 0, width, height));
    }
    
    /**
     * determines if a point is within the sprite's shape
     * 
     * @param ptX x-coordinate of the point to test
     * @param ptY y-coordinate of the point to test
     * @return true if point is in the shape, false otherwise
     */
    @Override
    public boolean intersects(double ptX, double ptY) {
      return ((getMinX() <= ptX) && (ptX < getMaxX()) &&
          (getMinY() <= ptY) && (ptY < getMaxY()));
    }

}