package fang2.sprites;

import fang2.attributes.Location2D;

import java.awt.geom.Point2D;

/**
 * This sprite draws a line between two points. This class exists
 * primary to give a simple name to a simple sprite. It is a less
 * general form of PolyLineSprite.
 *
 * @author  Jam Jenkins
 * @author  Brian C. Ladd
 */
public class LineSprite
  extends PolyLineSprite {
  Location2D start;
  Location2D end;

  /**
   * makes a line between the first point and the second point
   *
   * @param  start  the first point
   * @param  end    the second point
   */
  public LineSprite(Location2D start, Location2D end) {
    super(start, end);
    this.start = start;
    this.end = end;
  }

  /**
   * makes a line between the first point and the second point
   *
   * @param  x0  the horizontal location of the first point
   * @param  y0  the vertical location of the first point
   * @param  x1  the horizontal location of the second point
   * @param  y1  the vertical location of the second point
   */
  public LineSprite(double x0, double y0, double x1, double y1) {
    this(new Location2D(x0, y0), new Location2D(x1, y1));
  }

  /**
   * makes a line between the first point and the second point
   *
   * @param  endPointA  the first point
   * @param  endPointB  the second point
   */
  public LineSprite(Point2D.Double endPointA,
    Point2D.Double endPointB) {
    this(new Location2D(endPointA), new Location2D(endPointB));
  }

  /**
   * makes a line between (0, 0) and (1, 1)
   */
  public LineSprite() {
    this(0, 0, 1, 1);
  }

  /**
   * Return the start of the line, the beginning endpoint.
   *
   * @return  the start
   */
  public Location2D getStart() {
    return start;
  }

  /**
   * Reset the start point of the line to the given location
   *
   * @param  start  the start to set
   */
  public void setStart(Location2D start) {
    this.start = start;
    this.initPath(start, end);
  }

  /**
   * Reset the start point of the line to the point represented by (x,
   * y).
   *
   * @param  x  x-coordinate of the new start point
   * @param  y  y-coordinate of the new start point
   */
  public void setStart(double x, double y) {
    this.setStart(new Location2D(x, y));
  }

  /**
   * Return the end of the line, the final endpoint
   *
   * @return  the end
   */
  public Location2D getEnd() {
    return end;
  }

  /**
   * Reset the end point of the line to the given location
   *
   * @param  end  the end to set
   */
  public void setEnd(Location2D end) {
    this.end = end;
    this.initPath(start, end);
  }

  /**
   * Reset the end point of the line to the point represented by (x, y)
   *
   * @param  x  x-coordinate of the new end point
   * @param  y  y-coordinate of the new end point
   */
  public void setEnd(double x, double y) {
    this.setEnd(new Location2D(x, y));
  }
}
