package fang2.sprites;
//start auto-imports
import java.util.*;
import java.util.regex.*;
import java.awt.event.*;
//end auto-imports

import fang2.core.*;


/**
 * This is a StringSprite that changes when text is typed on it.
 * Note: this sprite must be on the screen (but not necessarily visible)
 * in order to receive keyboard input.
 * @author Jam Jenkins
 */
public class InputStringSprite extends StringSprite
{
	/**which players can enter text*/
	private final ArrayList<Integer> players;

	/**
	 * creates an sprite where only the first player can give input
	 */
	public InputStringSprite()
	{
		this(0);
	}

	/**
	 * creates an sprite where many players can give input
	 * @param playerIndex the list of players who are allowed to type
	 */
	public InputStringSprite(int ... playerIndex)
	{
		players=new ArrayList<Integer>();
		for(int p: playerIndex)
			players.add(p);
		leftJustify();
		topJustify();
	}

	/**
	 * allows the given players to type into the field
	 * @param playerIndex all of the player numbers who can type in the field
	 */
	public void addPlayerInput(int ... playerIndex)
	{
		for(int p: playerIndex)
			if(!players.contains(p))
				players.add(p);
	}

	/**
	 * keeps the given players from typing into the field
	 * @param playerIndex all of the player numbers who cannot type in the field
	 */
	public void removePlayerInput(int ... playerIndex)
	{
		for(int p: playerIndex)
			if(players.contains(p))
				players.remove(players.indexOf(p));
	}
	
	/**
	 * makes it so that no player can enter text
	 */
	public void clearPlayerInput()
	{
		players.clear();
	}

	/**
	 * @param playerIndex the player to see if capable of input
	 * @return true if the player can add to the field, false otherwise
	 */
	public boolean canInput(int playerIndex)
	{
		return players.contains(playerIndex);
	}

	/**
	 * responds to keyboard input by adding letters to the sprite
	 */
	public void update()
	{
		//super.update();
		for(int index: players)
		{
			if(Game.getCurrentGame().keyPressed(index))
			{
				char letter=Game.getCurrentGame().getKeyPressed(index);
				//handle backspace specially
				if(letter==KeyEvent.VK_BACK_SPACE || 
						letter==KeyEvent.VK_DELETE)
				{
					String contents=getText();
					if(contents.length()>0)
						setText(contents.substring(0, contents.length()-1));
				}
				//handle enter key specially
				else if(letter==KeyEvent.VK_ENTER)
				{
					setText(getText()+"\n");
				}
				//filter out only printable characters
				else
				{
					if(Pattern.matches("\\p{Print}", ""+letter))
						setText(getText()+letter);
				}
			}
		}
	}
}
