package fang2.core;

import java.io.*;
import java.util.regex.Pattern;

/**
 * This class moves and refactors all of the packaged
 * classes into the single package fang for easy
 * importing.  The refactoring is very basic.
 * @author Jam Jenkins
 */
public class FangPackageGenerator
{
	private static void copyResources(File fromDirectory, File toDirectory) throws Exception
	{
		for(File from: fromDirectory.listFiles())
		{
			if(from.isFile())
			{
				copyFile(from, toDirectory);
			}
			else
			{
				File newDir=new File(toDirectory.getAbsolutePath()+"/"+from.getName());
				newDir.mkdir();
				copyResources(from, newDir);
			}
		}
	}
	
	private static void copyFile(File from, File toDir) throws Exception
	{
		File target=new File(toDir.getAbsolutePath()+"/"+from.getName());
		FileOutputStream out=new FileOutputStream(target);
		FileInputStream in=new FileInputStream(from);
		byte[] buffer=new byte[1024];
		int read=in.read(buffer);
		while(read>=0)
		{
			out.write(buffer, 0, read);
			read=in.read(buffer);
		}
		out.close();
		in.close();
	}
	
    /**
     * Copies and refactors classes from subpackages
     * to the primary package fang.  The refactoring
     * is 1. change the package statement and 
     * 2. remove all imports of fang subpackages. 
     * @param args
     * @throws Exception
     */
    public static void main(String[] args)
    throws Exception
    {
    	String src="src/";
    	
    	File resources=new File(src+"fang2/resources");
    	resources.mkdir();
    	copyResources(new File(src+"fang2/ui/resources"), resources);
        //Note 1: it is important that experimental
        //is first so that if there are conflicting
        //filenames, only the stable one makes it.
        //Note 2: the package fang.resources must
        //contain the same contents as fang.ui.resources
        File[] directoriesToCopy =
            {
                new File(src+"fang2/attributes"),
                new File(src+"fang2/core"),
                new File(src+"fang2/media"),
                new File(src+"fang2/network"),
                new File(src+"fang2/sprites"),
                new File(src+"fang2/transformers"),
                new File(src+"fang2/ui"),
                new File(src+"fang2/util"),
            };
        for (File directory: directoriesToCopy)
        {
            for (File file: directory.listFiles())
            {
                if (file.isFile())
                {
                    if (file.getName().endsWith(".java"))
                    {
                        String targetName = src+"fang2/" + file.getName();
                        FileWriter target = new FileWriter(targetName);
                        FileReader source = new FileReader(file);
                        BufferedReader reader = new BufferedReader(source);
                        PrintWriter writer = new PrintWriter(target);
                        String line = reader.readLine();
                        while (line != null)
                        {
                            if (line.startsWith("package"))
                                line = "package fang2;";
                            if(line.trim().startsWith("import static fang2"))
                            {
                                String[] parts=line.split(Pattern.quote("."));
                                line="import static fang2."+
                                    parts[parts.length-2]+"."+
                                    parts[parts.length-1];
                            }
                            if (!line.startsWith("import fang2"))
                                writer.println(line);
                            line = reader.readLine();
                        }
                        reader.close();
                        writer.close();
                    }
                }

            }
        }
    }
}
