package fang2.core;

/**
 * This class is used to make something happen at a particular time.
 * TimeAction is used most often when extending
 * Game and calling the schedule method.  It can
 * also be used by the ButtonSprite to enable
 * an action to occur when the button is clicked.
 * @author Jam Jenkins & the FANG Team
 *
 */
public abstract class AlarmAdapter
            implements Alarm
{
    /**the current game running.
     * The game variable should not be used directly
     * when extending this class.  Instead call the
     * getGame method.
     */
    protected Game game = GameRedirection.getCurrentGame();

    /**
     * gets the current game running.
     * Use this method to interact with the current
     * game.  Games made using the FANG Engine can
     * include several games in sequence, which is
     * the reason there is a current game.
     * @return
     */
    protected Game getGame()
    {
        Game game = GameRedirection.getCurrentGame();
        if (game == null)
        {
            //add to error console here later
        }
        return game;
    }

    /**
     * this method is called from the FANG Engine.
     * Implement this method to determine what
     * should happen when the TimedAction occurs.
     */
    public abstract void act();
}