package fang2.attributes;

import java.awt.geom.Dimension2D;

/**
 * This class encapsulates a width and a height dimension.
 * 
 * @author Robert c. Duvall
 */
public class Size2D
  extends Dimension2D {
  /** The width of this size. */
  private double width;
  /** The height of this size */
  private double height;

  /**
   * Construct a new {@code Size2D} with the given dimensions.
   * 
   * @param width width of the size
   * @param height height of the size
   */
  public Size2D(double width, double height) {
    setSize(width, height);
  }

  /**
   * Construct a new square size
   * 
   * @param size width and height of the size
   */
  public Size2D(double size) {
    this(size, size);
  }

  /**
   * Construct a default, zero by zero, size.
   */
  public Size2D() {
    this(0);
  }

  /**
   * Construct a new {@code Size2D} to match the given size.
   * 
   * @param other the {@code Size2D} to match
   */
  public Size2D(Size2D other) {
    this(other.getWidth(), other.getHeight());
  }

  /**
   * Construct a new {@code Size2D} to match the given dimension.
   * 
   * @param dimensionToMatch the {@link java.awt.geom.Dimension2D
   *          Dimension2D} to match with our new size.
   */
  public Size2D(Dimension2D dimensionToMatch) {
    this(dimensionToMatch.getWidth(), dimensionToMatch.getHeight());
  }

  /**
   * Return the width of the size.
   * 
   * @return width of the size
   */
  @Override
  public double getWidth() {
    return width;
  }

  /**
   * Return the height of the size.
   * 
   * @return the height of the size
   */
  @Override
  public double getHeight() {
    return height;
  }

  /**
   * Test whether the other object is a {@code Size2D} that is the same
   * as this one (as in has the same size).
   * 
   * @param o the object to check for equality
   * @return true if this is equal to o; false otherwise
   */
  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    else if (o == null)
      return false;
    else if (o.getClass() != getClass())
      return false;
    else {
      Size2D other = (Size2D) o;
      return (getWidth() == other.getWidth()) &&
             (getHeight() == other.getHeight());
    }
  }

  /**
   * Set the size of this object to the size given.
   * 
   * @param width new width
   * @param height new height
   */
  @Override
  public void setSize(double width, double height) {
    this.width = width;
    this.height = height;
  }

  /**
   * Set the size of this object to the size given.
   * 
   * @param other the {@code Size2D} to match the size of
   */
  public void setSize(Size2D other) {
    setSize(other.getWidth(), other.getHeight());
  }

  /**
   * Set the size of this object to the size given.
   * 
   * @param dimensionToMatch the {@code Dimension2D} to match
   */
  @Override
  public void setSize(Dimension2D dimensionToMatch) {
    setSize(dimensionToMatch.getWidth(), dimensionToMatch.getHeight());
  }

  /**
   * Return a string representation of the {@code Size2D}
   */
  @Override
  public String toString() {
    return getClass().getName() + "[w=" + width + ",h=" + height + "]";
  }
}
