/*
 * Decompiled with CFR 0.152.
 */
package fang2.util;

import fang2.core.GameLoop;
import fang2.ui.GameWindow;
import fang2.util.DOSCommandLine;
import fang2.util.ErrorException;
import fang2.util.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeApplication {
    public static final String ARGS = "UNAMED_ARGS";
    private static Map<String, ArrayList<String>> argDictionary = new HashMap<String, ArrayList<String>>();

    public static void fangMain(String[] stringArray) {
        String string;
        argDictionary.putAll(InitializeApplication.parameterDictionary(stringArray));
        String string2 = null;
        if (argDictionary.containsKey("game")) {
            string2 = argDictionary.get("game").get(0);
        }
        Class<?> clazz = null;
        GameWindow gameWindow = null;
        if (string2 == null) {
            try {
                string2 = System.getProperty("java.main");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string = InitializeApplication.getCommandLine();
            string2 = InitializeApplication.readMainClassFromCommandLine(string);
        }
        if (string2 != null) {
            if (string2.endsWith(".class")) {
                string2 = string2.substring(0, string2.length() - 6);
            }
            string2 = string2.replace('/', '.');
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            try {
                string = clazz.newInstance();
                if (string instanceof GameLoop) {
                    gameWindow = (GameLoop)((Object)string);
                } else {
                    string2 = null;
                    if (argDictionary.containsKey("game")) {
                        string2 = argDictionary.get("game").get(0);
                    }
                    if (string2 == null) {
                        throw new ErrorException("Main class does not specify a game");
                    }
                    gameWindow = (GameLoop)Class.forName(string2).newInstance();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (gameWindow == null) {
            throw new ErrorException("Cannot determine the game class.");
        }
        gameWindow.runAsApplication();
    }

    public static ArrayList<String> getArgumentNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : argDictionary.keySet()) {
            if (string.equals(ARGS)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ArrayList<String> getNamedArgs(String string) {
        return argDictionary.get(string);
    }

    public static ArrayList<String> getUnnamedArgs() {
        return argDictionary.get(ARGS);
    }

    private static String getShellCommandLine() {
        try {
            String string = Platform.isMac() ? "command" : "args";
            String[] stringArray = new String[]{"bash", "-c", "ps ww -p $PPID -o " + string};
            Process process = Runtime.getRuntime().exec(stringArray);
            process.waitFor();
            if (process.getErrorStream().read() != -1) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            bufferedReader.readLine();
            return bufferedReader.readLine();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String readMainClassFromManifest(String string) {
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry("META-INF/MANIFEST.MF");
            if (zipEntry == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry)));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                if (string2.startsWith("Main-Class:")) {
                    return string2.substring("Main-Class:".length()).trim();
                }
                string2 = bufferedReader.readLine();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static String getCommandLine() {
        switch (Platform.getPlatform()) {
            case 1: 
            case 2: {
                return InitializeApplication.getShellCommandLine();
            }
            case 3: {
                return DOSCommandLine.getCommandLine();
            }
        }
        return null;
    }

    protected static Map<String, ArrayList<String>> parameterDictionary(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            if (n > 0) {
                String string2 = string.substring(0, n).toLowerCase();
                String string3 = string.substring(n + 1);
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, new ArrayList());
                }
                ((ArrayList)hashMap.get(string2)).add(string3);
                continue;
            }
            arrayList.add(string);
        }
        hashMap.put(ARGS, arrayList);
        return hashMap;
    }

    protected static String readMainClassFromCommandLine(String string) {
        if (string == null) {
            return null;
        }
        boolean bl = false;
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.quoteChar(34);
            streamTokenizer.quoteChar(39);
            streamTokenizer.whitespaceChars(32, 32);
            streamTokenizer.whitespaceChars(9, 9);
            boolean bl2 = false;
            while (true) {
                int n = streamTokenizer.nextToken();
                String string2 = streamTokenizer.sval;
                switch (n) {
                    case -1: {
                        return null;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (bl2) {
                    if (string2.startsWith("-")) {
                        if (string2.equals("-jar")) {
                            bl = true;
                            continue;
                        }
                        if (!string2.equals("-cp") && !string2.equals("-classpath")) continue;
                        streamTokenizer.nextToken();
                        continue;
                    }
                    if (bl) {
                        return InitializeApplication.readMainClassFromManifest(string2);
                    }
                    return string2;
                }
                bl2 = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void setParameter(String string, String string2) {
        if (!argDictionary.containsKey(string)) {
            argDictionary.put(string, new ArrayList());
        }
        argDictionary.get(string).add(string2);
    }
}

