/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import fang2.core.AlarmAdapter;
import fang2.core.Game;
import fang2.core.Player;
import fang2.sprites.InputStringField;
import fang2.sprites.StringSprite;

public class PlayerNameInput
extends Game {
    private InputStringField[] box;
    private StringSprite status;
    private StringSprite names;
    private int namesLeft;

    public void setup() {
        int n;
        for (n = 0; n < this.getNumberOfPlayers(); ++n) {
            if (this.getPlayerName(n).equals(Player.getDefaultName(n))) continue;
            this.namesLeft = 0;
            this.finishGame();
            return;
        }
        this.namesLeft = this.getNumberOfPlayers();
        this.status = new StringSprite("Waiting for ALL other players.");
        this.status.setWidth(0.9);
        this.status.setLineHeight(0.05);
        this.status.bottomJustify();
        this.status.leftJustify();
        this.status.setLocation(0.05, 0.95);
        this.addSprite(this.status);
        this.names = new StringSprite();
        this.names.setWidth(0.9);
        this.names.setLineHeight(0.05);
        this.names.topJustify();
        this.names.leftJustify();
        this.names.setLocation(0.05, 0.3);
        this.addSprite(this.names);
        this.box = new InputStringField[this.getNumberOfPlayers()];
        for (n = 0; n < this.box.length; ++n) {
            this.box[n] = new InputStringField(0.9, 0.1, n);
            this.box[n].setLocation(0.5, 0.2);
            this.box[n].setLabelText("Type your name here and press Enter");
            this.addSprite(this.box[n]);
            this.box[n].setVisible(n == this.getPlayerID());
        }
        this.updatePlayerNames();
    }

    private void updatePlayerNames() {
        String string = "";
        this.namesLeft = this.getNumberOfPlayers();
        for (int i = 0; i < this.box.length; ++i) {
            if (this.box[i].hasEnteredText()) {
                this.setPlayerName(this.box[i].getEnteredText(), i);
                string = string + "Player " + i + ": " + this.box[i].getEnteredText() + "\n";
                --this.namesLeft;
                continue;
            }
            string = string + "Player " + i + ": unknown\n";
        }
        this.names.setText(string);
        this.names.setWidth(0.9);
        if (this.names.getHeight() > 0.5) {
            this.names.setHeight(0.5);
        }
        if (this.namesLeft > 0) {
            this.status.setText("Waiting for " + this.namesLeft + " other players.");
        } else {
            this.status.setText("All players named, starting game...");
            this.schedule(new StartRealGame(), 1.0);
        }
    }

    public void advance() {
        if (this.namesLeft > 0) {
            this.updatePlayerNames();
        }
    }

    class StartRealGame
    extends AlarmAdapter {
        StartRealGame() {
        }

        public void act() {
            PlayerNameInput.this.finishGame();
        }
    }
}

