/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import fang2.core.AnimationCanvas;
import fang2.core.GameLoop;
import fang2.core.Sound;
import fang2.network.Client;
import fang2.sprites.ButtonSprite;
import fang2.sprites.ImageSprite;
import fang2.ui.ButtonCanvas;
import fang2.ui.FunButton;
import fang2.ui.FunComboBox;
import fang2.ui.FunPainter;
import fang2.ui.FunPanel;
import fang2.ui.FunTextField;
import fang2.ui.HTMLDisplay;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class GameWindow
extends JApplet
implements ActionListener,
WindowStateListener {
    protected JFrame frame;
    protected JLabel loadingMessage;
    protected JTextField sessionLabel;
    protected JTextField serverLabel;
    protected CardLayout cards;
    protected Container container;
    protected ButtonSprite pause;
    protected ButtonSprite quit;
    protected ButtonSprite helpPlay;
    protected ButtonSprite mute;
    protected FunButton connectButton;
    protected FunComboBox sessionComboBox;
    protected JTextField serverField;
    protected JTextField playersSpinner;
    protected JLabel title;
    protected HTMLDisplay help;
    protected boolean createOwnFrame;
    public int players = 1;
    public boolean playersSelectable = true;
    public boolean serverSelectable = true;
    public boolean sessionSelectable = true;
    public static boolean displayControlButtons = true;
    private ButtonCanvas control;
    public boolean fullScreen = false;

    public GameWindow() {
        this.setCreateOwnFrame(false);
    }

    protected void setCreateOwnFrame(boolean bl) {
        this.createOwnFrame = bl;
    }

    protected boolean isCreatingOwnFrame() {
        return this.createOwnFrame;
    }

    public void runAsApplication() {
        this.setCreateOwnFrame(true);
        this.init();
        if (this.frame.getTitle().equals("")) {
            this.frame.setTitle(this.getGameName());
        }
    }

    public abstract void setGameName(String var1);

    public abstract String getGameName();

    public void setTitle(String string) {
        this.title.setText(string);
        if (this.frame != null) {
            this.frame.setTitle(string);
        }
    }

    public abstract void setNumberOfPlayers(int var1);

    public abstract void setServerName(String var1);

    public abstract void setSessionName(String var1);

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pause) {
            this.pauseToggle();
        } else if (object == this.quit) {
            this.exitGame();
        } else if (object == this.helpPlay) {
            if (this.help == null) {
                this.setDefaultHelp();
            }
            this.help.setVisible(true);
        } else if (object == this.mute) {
            this.toggleAudible();
        }
    }

    protected void toggleAudible() {
        if (this.mute.getText().equals("Mute")) {
            this.mute.setText("Sound");
            this.control.repaint();
            Sound.muteAll();
        } else {
            this.mute.setText("Mute");
            this.control.repaint();
            Sound.turnAllSoundOn();
        }
    }

    private void exitGame() {
        this.disconnect();
        if (this.frame != null) {
            this.frame.dispose();
        }
        try {
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void disconnect();

    protected void pauseToggle() {
        if (this.pause.getText().equals("Start") || this.pause.getText().equals("Resume")) {
            this.pause.setText("Pause");
            this.control.repaint();
            Sound.resumeAll();
        } else {
            this.pause.setText("Resume");
            this.control.repaint();
            Sound.pauseAll();
        }
    }

    public void setHelp(String string) {
        if (this.help == null) {
            this.setDefaultHelp();
        }
        this.help.setContent(string, GameLoop.getGameResource(string));
    }

    public void setHelpText(String string) {
        this.help.setText(string);
    }

    protected void setDefaultHelp() {
        this.help = new HTMLDisplay("resources/DefaultHelp.html", GameWindow.class.getResource("resources/DefaultHelp.html"));
        URL uRL = this.getHelpStyleSheet();
        if (uRL != null) {
            this.help.setStyleSheet(uRL);
        }
    }

    protected URL getHelpStyleSheet() {
        return null;
    }

    protected Dimension getDefaultSize() {
        return new Dimension(400, 400);
    }

    public void windowStateChanged(WindowEvent windowEvent) {
        if (windowEvent.getNewState() == 201) {
            this.exitGame();
        }
    }

    private void makeComponents() {
        Dimension dimension = this.getSize();
        if (this.createOwnFrame) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            this.frame = new JFrame("", graphicsDevice.getDefaultConfiguration());
            this.frame.addWindowListener(new WindowCloser());
            dimension = this.getCanvas().getSize();
        }
        dimension.width = 2 * dimension.width / 3;
        dimension.height = 2 * dimension.height / 3;
        this.control = new ButtonCanvas(this.getCanvas());
        this.control.addActionListeners(this, this, this, this);
        this.pause = this.control.getPause();
        this.mute = this.control.getMute();
        this.quit = this.control.getQuit();
        this.helpPlay = this.control.getHelp();
        dimension = this.createOwnFrame ? this.getCanvas().getSize() : this.getSize();
        this.title = new JLabel();
        FunPainter.setProperties(dimension, this.title);
        this.loadingMessage = new JLabel("Loading");
        FunPainter.setProperties(dimension, this.loadingMessage);
        if (this.help == null) {
            this.setDefaultHelp();
        }
    }

    public abstract String getSessionName();

    public abstract String getServerName();

    private void layoutComponents() {
        this.container = this.createOwnFrame ? this.frame.getContentPane() : this.getRootPane().getContentPane();
        this.cards = new CardLayout();
        this.container.setLayout(this.cards);
        this.container.add((Component)this.getGamePanel(), "Game");
        this.container.add((Component)this.getConnectionPanel(), "Connecting");
        this.container.add((Component)this.getStatusPanel(), "Loading Game");
    }

    private Container getGamePanel() {
        FunPanel funPanel = new FunPanel();
        funPanel.setLayout(new BorderLayout());
        funPanel.add((Component)this.getCanvas(), "Center");
        if (displayControlButtons) {
            funPanel.add((Component)this.control, "South");
        }
        funPanel.add((Component)this.title, "North");
        return funPanel;
    }

    private JPanel getStatusPanel() {
        FunPanel funPanel = new FunPanel(new BorderLayout());
        FunPanel funPanel2 = new FunPanel(new GridLayout(7, 1));
        Dimension dimension = this.createOwnFrame ? this.getCanvas().getSize() : this.getSize();
        JLabel jLabel = new JLabel(this.getGameName());
        FunPainter.setProperties(dimension, jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(jLabel.getFont().deriveFont((float)jLabel.getFont().getSize() * 1.5f));
        funPanel2.add(jLabel);
        jLabel = new JLabel("Name of this game:");
        FunPainter.setProperties(dimension, jLabel);
        funPanel2.add(jLabel);
        this.sessionLabel = new FunTextField(this.getSessionName(), dimension);
        this.sessionLabel.setEnabled(false);
        funPanel2.add(this.sessionLabel);
        FunPanel funPanel3 = new FunPanel(new BorderLayout());
        jLabel = new JLabel("Number of players:");
        FunPainter.setProperties(dimension, jLabel);
        funPanel3.add((Component)jLabel, "West");
        FunTextField funTextField = new FunTextField(dimension);
        funTextField.setText(funTextField.getText());
        funTextField.setEnabled(false);
        funPanel3.add((Component)funTextField, "Center");
        funPanel2.add(funPanel3);
        jLabel = new JLabel("Name of game server:");
        FunPainter.setProperties(dimension, jLabel);
        funPanel2.add(jLabel);
        this.serverLabel = new FunTextField(this.getServerName(), dimension);
        this.serverLabel.setEnabled(false);
        funPanel2.add(this.serverLabel);
        this.loadingMessage.setFont(this.loadingMessage.getFont().deriveFont(3));
        funPanel2.add(this.loadingMessage);
        jLabel = new JLabel("Game Engine by Jam");
        FunPainter.setProperties(dimension, jLabel);
        jLabel.setFont(new Font("monospaced", 1, jLabel.getFont().getSize() * 3 / 2));
        jLabel.setForeground(new Color(1.0f, 0.0f, 0.0f, 0.3f));
        funPanel.add((Component)funPanel2, "Center");
        funPanel.add((Component)jLabel, "South");
        return funPanel;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    private JPanel getConnectionPanel() {
        FunPanel funPanel = new FunPanel(new BorderLayout());
        FunPanel funPanel2 = new FunPanel(new GridLayout(7, 1));
        Dimension dimension = this.createOwnFrame ? this.getCanvas().getSize() : this.getSize();
        JLabel jLabel = new JLabel(this.getGameName());
        FunPainter.setProperties(dimension, jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(jLabel.getFont().deriveFont((float)jLabel.getFont().getSize() * 1.5f));
        funPanel2.add(jLabel);
        jLabel = new JLabel("Name of this game:");
        FunPainter.setProperties(dimension, jLabel);
        funPanel2.add(jLabel);
        this.sessionComboBox = new FunComboBox(new String[]{"default"}, dimension);
        this.sessionComboBox.addPopupMenuListener(new ShowPopup());
        this.sessionComboBox.setEditable(true);
        funPanel2.add(this.sessionComboBox);
        this.sessionComboBox.setEnabled(this.sessionSelectable);
        FunPanel funPanel3 = new FunPanel(new BorderLayout());
        jLabel = new JLabel("Number of players:");
        FunPainter.setProperties(dimension, jLabel);
        funPanel3.add((Component)jLabel, "West");
        this.playersSpinner = new FunTextField("" + this.players, dimension);
        funPanel3.add((Component)this.playersSpinner, "Center");
        this.playersSpinner.setEnabled(this.playersSelectable);
        funPanel2.add(funPanel3);
        jLabel = new JLabel("Name of game server:");
        FunPainter.setProperties(dimension, jLabel);
        funPanel2.add(jLabel);
        this.serverField = new FunTextField(dimension);
        try {
            if (this.getServerName().length() == 0 || this.getServerName().equals("localhost")) {
                if (this.getCodeBase() == null || this.getCodeBase().getHost() == null || this.getCodeBase().getHost().equals("") || this.getCodeBase().getHost().equals("localhost") || this.getCodeBase().getHost().equals(GameWindow.getHostname())) {
                    this.serverField.setText(GameWindow.getHostname());
                    this.setServerName(GameWindow.getHostname());
                    this.serverField.setEditable(true);
                } else {
                    this.serverField.setText(this.getCodeBase().getHost());
                    this.setServerName(this.getCodeBase().getHost());
                    this.serverField.setEditable(false);
                }
            } else {
                this.serverField.setText(this.getServerName());
            }
        }
        catch (NullPointerException nullPointerException) {
            this.serverField.setText(GameWindow.getHostname());
            this.serverField.setEditable(true);
        }
        this.serverField.setEnabled(this.serverSelectable);
        funPanel2.add(this.serverField);
        this.connectButton = new FunButton("Connect & Start Game", dimension);
        this.connectButton.addActionListener(new StartGame());
        funPanel2.add(this.connectButton);
        jLabel = new JLabel("Game Engine by Jam");
        FunPainter.setProperties(dimension, jLabel);
        jLabel.setFont(new Font("monospaced", 1, jLabel.getFont().getSize() * 3 / 2));
        jLabel.setForeground(new Color(1.0f, 0.0f, 0.0f, 0.3f));
        funPanel.add((Component)funPanel2, "Center");
        funPanel.add((Component)jLabel, "South");
        return funPanel;
    }

    public abstract AnimationCanvas getCanvas();

    public void setLoadMessage(String string) {
        this.loadingMessage.setText(string);
    }

    public abstract void begin();

    private void readParameters() {
        try {
            if (this.getParameter("players") != null) {
                this.players = new Integer(this.getParameter("players"));
                this.playersSpinner.setText("" + this.players);
                this.playersSelectable = this.getParameter("players-selectable") != null ? !this.getParameter("players-selectable").toLowerCase().trim().equals("false") : false;
            } else {
                this.players = 1;
            }
            if (this.getParameter("session") != null) {
                this.setSessionName(this.getParameter("session"));
            }
            if (this.getParameter("session-selectable") != null && this.getParameter("session-selectable").trim().toLowerCase().equals("false")) {
                this.sessionSelectable = false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getHash() {
        String string = this.getClass().getName();
        try {
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            Class<?> clazz = this.getClass();
            URL uRL = clazz.getResource(string2 + ".class");
            byte[] byArray = new byte[4];
            int n = -1;
            int n2 = 0;
            InputStream inputStream = uRL.openStream();
            do {
                int n3 = 0;
                do {
                    if ((n = inputStream.read(byArray, n3, 4 - n3)) >= 0) continue;
                    return "" + n2;
                } while ((n3 += n) < 4);
                for (int i = 0; i < n3; ++i) {
                    n2 ^= byArray[i] << i * 8;
                }
            } while (n >= 0);
            return "" + n2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public void init() {
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        this.setGameName(string2);
        this.readParameters();
        this.makeComponents();
        this.layoutComponents();
        this.cards.next(this.container);
        if (this.createOwnFrame) {
            if (this.fullScreen && this.frame.getGraphicsConfiguration().getDevice().isFullScreenSupported()) {
                this.frame.setUndecorated(true);
                this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(this.frame);
                this.frame.validate();
            }
            if (!this.fullScreen) {
                this.frame.pack();
            }
            this.frame.setVisible(true);
        }
        if (this.players == 1) {
            this.cards.next(this.container);
            this.setSessionName("default");
            this.setServerName("localhost");
            this.setNumberOfPlayers(1);
            new StartGame().start();
        } else if (!(this.playersSelectable || this.sessionSelectable || this.serverSelectable)) {
            this.connectButton.getActionListeners()[0].actionPerformed(null);
        }
        this.updateAvailableSessions();
    }

    private void updateAvailableSessions() {
        String[] stringArray;
        this.sessionComboBox.removeAllItems();
        for (String string : stringArray = Client.getWaitingSessions(this.getServerName(), this.getHash())) {
            this.sessionComboBox.addItem(string);
        }
    }

    public abstract void startGame();

    public void stop() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            GameWindow.this.exitGame();
        }
    }

    class StartGame
    extends Thread
    implements ActionListener {
        StartGame() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ImageSprite.configuration = GameWindow.this.getCanvas().getGraphicsConfiguration();
            GameWindow.this.begin();
            GameWindow.this.cards.next(GameWindow.this.container);
            FunPanel.stopUpdating();
            StartGame startGame = this;
            synchronized (startGame) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Integer.parseInt(GameWindow.this.playersSpinner.getText()) == 1) {
                GameWindow.this.setSessionName("default");
                GameWindow.this.setServerName("localhost");
                GameWindow.this.setNumberOfPlayers(1);
                GameWindow.this.cards.next(GameWindow.this.container);
                this.start();
                return;
            }
            GameWindow.this.serverLabel.setText(GameWindow.this.serverField.getText());
            GameWindow.this.setServerName(GameWindow.this.serverField.getText());
            GameWindow.this.sessionComboBox.actionPerformed(null);
            if (((String)GameWindow.this.sessionComboBox.getSelectedItem()).trim().length() == 0) {
                GameWindow.this.sessionComboBox.setSelectedItem("default");
            }
            GameWindow.this.sessionLabel.setText(((String)GameWindow.this.sessionComboBox.getSelectedItem()).trim());
            GameWindow.this.setSessionName(((String)GameWindow.this.sessionComboBox.getSelectedItem()).trim());
            GameWindow.this.setNumberOfPlayers(Integer.parseInt(GameWindow.this.playersSpinner.getText()));
            GameWindow.this.cards.next(GameWindow.this.container);
            this.start();
        }
    }

    class ShowPopup
    implements PopupMenuListener {
        ShowPopup() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            GameWindow.this.updateAvailableSessions();
            GameWindow.this.validate();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

