/*
 * Decompiled with CFR 0.152.
 */
package fang2.ui;

import fang2.core.AnimationCanvas;
import fang2.sprites.ButtonSprite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class ButtonCanvas
extends JComponent
implements MouseListener {
    private Point2D.Double press;
    private AnimationCanvas canvas;
    public static final double HEIGHT = 0.1;
    private static final long serialVersionUID = 1L;
    private ButtonSprite[] button;

    public ButtonCanvas(AnimationCanvas animationCanvas) {
        this.canvas = animationCanvas;
        this.setSize(new Dimension(1, 1));
        this.setFocusable(true);
        this.makeButtons();
        this.addMouseListener(this);
    }

    private void makeButtons() {
        this.button = new ButtonSprite[4];
        double d = 1.0 / (double)this.button.length / 0.09;
        this.button[0] = new ButtonSprite("Start", d);
        this.button[1] = new ButtonSprite("Sound", d);
        this.button[2] = new ButtonSprite("Help", d);
        this.button[3] = new ButtonSprite("Quit", d);
        for (int i = 0; i < this.button.length; ++i) {
            this.button[i].setScale(0.24);
            this.button[i].setLocation(((double)i + 0.5) / (double)this.button.length, 0.05);
        }
    }

    public void paintImmediately() {
        this.paintImmediately(0, 0, this.getSize().width, this.getSize().height);
    }

    private double getScalingFactor() {
        return this.canvas.getWidth();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        double d = this.getScalingFactor();
        graphics2D.transform(AffineTransform.getScaleInstance(d, d));
        for (ButtonSprite buttonSprite : this.button) {
            buttonSprite.paint(graphics2D);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)this.getScalingFactor(), (int)(0.1 * this.getScalingFactor()));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private Point2D.Double scaledPoint(Point point) {
        return new Point2D.Double((double)point.x / this.getScalingFactor(), (double)point.y / this.getScalingFactor());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.press = this.scaledPoint(point);
        for (ButtonSprite buttonSprite : this.button) {
            if (!buttonSprite.intersects(this.press)) continue;
            buttonSprite.lower();
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        for (ButtonSprite buttonSprite : this.button) {
            buttonSprite.raise();
        }
        Point point = mouseEvent.getPoint();
        Point2D.Double double_ = this.scaledPoint(point);
        for (ButtonSprite buttonSprite : this.button) {
            if (!buttonSprite.intersects(double_) || !buttonSprite.intersects(this.press)) continue;
            buttonSprite.executePressAction();
        }
        this.repaint();
    }

    public void addActionListeners(ActionListener ... actionListenerArray) {
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.button[i].addActionListener(actionListenerArray[i]);
        }
    }

    public ButtonSprite getPause() {
        return this.button[0];
    }

    public ButtonSprite getMute() {
        return this.button[1];
    }

    public ButtonSprite getQuit() {
        return this.button[3];
    }

    public ButtonSprite getHelp() {
        return this.button[2];
    }
}

