/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Location2D;
import fang2.attributes.Vector2D;
import fang2.core.TransformerAdapter;
import fang2.transformers.VelocityProvider;

public class VelocityTransformer
extends TransformerAdapter
implements VelocityProvider {
    private Vector2D velocity;
    private double maximumMagnitude;
    private double minimumMagnitude;
    private double nominalMagnitude;
    private boolean resetToNominal;

    public VelocityTransformer(Vector2D vector2D) {
        this.velocity = vector2D;
        this.maximumMagnitude = Double.MAX_VALUE;
        this.minimumMagnitude = 0.0;
        this.nominalMagnitude = 0.0;
        this.resetToNominal = false;
    }

    public VelocityTransformer(double d, double d2) {
        this(new Vector2D(d, d2));
    }

    public VelocityTransformer() {
        this(0.0, 0.0);
    }

    public double getMaximumMagnitude() {
        return this.maximumMagnitude;
    }

    public double getMinimumMagnitude() {
        return this.minimumMagnitude;
    }

    public double getNominalMagnitude() {
        return this.nominalMagnitude;
    }

    public void setMaximumMagnitude(double d) {
        this.maximumMagnitude = d;
    }

    public void setMinimumMagnitude(double d) {
        this.minimumMagnitude = d;
    }

    public void setNominalMagnitude(double d) {
        this.nominalMagnitude = d;
    }

    public Vector2D getVelocity() {
        return this.velocity;
    }

    public void nonMaskableAdvance(double d) {
        if (this.resetToNominal()) {
            this.velocity.setMagnitude(this.nominalMagnitude);
        }
    }

    public boolean resetToNominal() {
        return this.resetToNominal;
    }

    public void setResetToNominal(boolean bl) {
        this.resetToNominal = bl;
    }

    public void setVelocity(Vector2D vector2D) {
        this.velocity = new Vector2D(vector2D);
        this.boundMagnitude();
    }

    public void setVelocity(Location2D location2D) {
        this.velocity.setXYChange(location2D.getX(), location2D.getY());
        this.boundMagnitude();
    }

    public void advance(double d) {
        this.setLocation(new Location2D(this.velocity.multiply(d)));
    }

    private void boundMagnitude() {
        double d = this.velocity.getMagnitude();
        if (d > this.maximumMagnitude) {
            this.velocity.setMagnitude(this.maximumMagnitude);
        }
        if (d < this.minimumMagnitude) {
            this.velocity.setMagnitude(this.minimumMagnitude);
        }
    }
}

