/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.core.Sprite;
import fang2.transformers.InterpolatorTransformer;
import java.awt.Color;

public class ColorTransformer
extends InterpolatorTransformer {
    private Color currColor;
    private final float[] currColorComponents;
    private Color endColor;
    private final float[] endColorComponents;
    private Color startColor;
    private final float[] startColorComponents = new float[4];

    public ColorTransformer(double d, boolean bl, Color color, Color color2) {
        super(d, bl);
        this.currColorComponents = new float[4];
        this.endColorComponents = new float[4];
        this.setStartColor(color);
        this.setEndColor(color2);
    }

    public ColorTransformer(double d, Color color, Color color2) {
        this(d, true, color, color2);
    }

    public Color getEndColor() {
        return this.endColor;
    }

    public Color getStartColor() {
        return this.startColor;
    }

    public void setEndColor(Color color) {
        this.endColor = color;
        this.endColor.getComponents(this.endColorComponents);
    }

    public void setStartColor(Color color) {
        this.startColor = color;
        this.startColor.getComponents(this.startColorComponents);
    }

    public void updateSprite(Sprite sprite) {
        sprite.setColor(this.currColor);
    }

    protected void interpolate(double d) {
        for (int i = 0; i != 4; ++i) {
            this.currColorComponents[i] = (float)((1.0 - d) * (double)this.startColorComponents[i] + d * (double)this.endColorComponents[i]);
        }
        this.currColor = new Color(this.currColorComponents[0], this.currColorComponents[1], this.currColorComponents[2], this.currColorComponents[3]);
    }
}

