/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Location2D;
import fang2.attributes.Vector2D;
import fang2.core.Sprite;
import fang2.core.Transformer;
import fang2.transformers.VelocityProvider;

public class BounceTransformer
implements Transformer,
VelocityProvider {
    public static final double threshold = 0.0;
    private double elasticity;
    protected final VelocityProvider modified;

    public BounceTransformer(VelocityProvider velocityProvider) {
        this.modified = velocityProvider;
        this.elasticity = 1.0;
    }

    public void advance(double d) {
        this.modified.advance(d);
    }

    public double getElacticity() {
        return this.elasticity;
    }

    public Vector2D getVelocity() {
        return this.modified.getVelocity();
    }

    public void nonMaskableAdvance(double d) {
        this.modified.nonMaskableAdvance(d);
    }

    public void setElasticity(double d) {
        this.elasticity = d;
    }

    public void setVelocity(Location2D location2D) {
        this.modified.setVelocity(location2D);
    }

    public void setVelocity(Vector2D vector2D) {
        this.modified.setVelocity(vector2D);
    }

    public void updateSprite(Sprite sprite) {
        this.modified.updateSprite(sprite);
    }

    protected void bounceX() {
        Vector2D vector2D = this.getVelocity();
        double d = vector2D.getX() * this.elasticity;
        double d2 = vector2D.getY();
        if (Math.abs(d) <= 0.0) {
            d = 0.0;
        }
        this.setVelocity(vector2D.setXYChange(-d, d2));
    }

    protected void bounceY() {
        Vector2D vector2D = this.getVelocity();
        double d = vector2D.getX();
        double d2 = vector2D.getY() * this.elasticity;
        if (Math.abs(d2) <= 0.0) {
            d2 = 0.0;
        }
        this.setVelocity(vector2D.setXYChange(d, -d2));
    }
}

