/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Box2D;
import fang2.attributes.Location2D;
import fang2.attributes.Vector2D;
import fang2.core.Sprite;
import fang2.transformers.BounceTransformer;
import fang2.transformers.VelocityProvider;
import fang2.transformers.VelocityTransformer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BounceSpriteTransformer
extends BounceTransformer {
    private final List<Sprite> targets = new ArrayList<Sprite>();
    private double deltaT;
    private boolean useBoundingBox = true;

    public BounceSpriteTransformer(Sprite sprite) {
        this(sprite, new VelocityTransformer(new Vector2D()));
    }

    public BounceSpriteTransformer(Sprite sprite, VelocityProvider velocityProvider) {
        super(velocityProvider);
    }

    public BounceSpriteTransformer(Sprite sprite, VelocityProvider velocityProvider, Sprite sprite2) {
        this(sprite, velocityProvider);
        this.add(sprite2);
    }

    public void add(Sprite sprite) {
        if (sprite != null && this.targets.indexOf(sprite) < 0) {
            this.targets.add(sprite);
        }
    }

    @Override
    public void advance(double d) {
        this.deltaT = d;
        super.advance(d);
    }

    @Override
    public void updateSprite(Sprite sprite) {
        for (Sprite sprite2 : this.targets) {
            if (sprite2 == sprite || !sprite.intersects(sprite2)) continue;
            this.bounce(sprite, sprite2, sprite.getLocation().add(this.getVelocity().multiply(-this.deltaT)), this.deltaT);
        }
        super.updateSprite(sprite);
    }

    public void clear() {
        this.targets.clear();
    }

    public List<Sprite> getTargets() {
        return this.targets;
    }

    public boolean getUseBoundingBox() {
        return this.useBoundingBox;
    }

    public void remove(Sprite sprite) {
        this.targets.remove(sprite);
    }

    public void setUseBoundingBox(boolean bl) {
        this.useBoundingBox = true;
    }

    private void bounce(Sprite sprite, Sprite sprite2, Location2D location2D, double d) {
        if (this.useBoundingBox) {
            Box2D box2D;
            double d2 = sprite.getX() - sprite2.getX();
            double d3 = sprite.getY() - sprite2.getY();
            Location2D location2D2 = (box2D = sprite2.getBounds2D()).contains(sprite.getLocation()) ? location2D : sprite.getLocation();
            int n = box2D.outcode(location2D2);
            if ((n & 5) != 0 && Math.signum(d2) != Math.signum(this.getVelocity().getX())) {
                this.bounceX();
                if ((n & 1) != 0 && sprite.getMaxX() > sprite2.getMinX()) {
                    sprite.translateX(sprite2.getMinX() - sprite.getMaxX());
                }
                if ((n & 4) != 0 && sprite.getMinX() < sprite2.getMaxX()) {
                    sprite.translateX(sprite2.getMaxX() - sprite.getMinX());
                }
            }
            if ((n & 0xA) != 0 && Math.signum(d3) != Math.signum(this.getVelocity().getY())) {
                this.bounceY();
                if ((n & 2) != 0 && sprite.getMaxY() > sprite2.getMinY()) {
                    sprite.translateY(sprite2.getMinY() - sprite.getMaxY());
                }
                if ((n & 8) != 0 && sprite.getMinY() < sprite2.getMaxY()) {
                    sprite.translateY(sprite2.getMaxY() - sprite.getMinY());
                }
            }
        }
    }
}

