/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Vector2D;
import fang2.core.Sprite;
import fang2.transformers.BounceTransformer;
import fang2.transformers.VelocityProvider;
import fang2.transformers.VelocityTransformer;

public class BounceInsideRectangleTransformer
extends BounceTransformer {
    private final double maxX;
    private final double maxY;
    private final double minX;
    private final double minY;

    public BounceInsideRectangleTransformer() {
        this(new VelocityTransformer(new Vector2D()));
    }

    public BounceInsideRectangleTransformer(double d, double d2, double d3, double d4, VelocityProvider velocityProvider) {
        super(velocityProvider);
        this.minX = d;
        this.minY = d2;
        this.maxX = d3;
        this.maxY = d4;
    }

    public BounceInsideRectangleTransformer(VelocityProvider velocityProvider) {
        this(0.0, 0.0, 1.0, 1.0, velocityProvider);
    }

    public void advance(double d) {
        super.advance(d);
    }

    public void updateSprite(Sprite sprite) {
        super.updateSprite(sprite);
        if (sprite.getMinX() < this.minX || this.maxX < sprite.getMaxX()) {
            this.bounceX();
        }
        if (sprite.getMinY() < this.minY || this.maxY < sprite.getMaxY()) {
            this.bounceY();
        }
        if (sprite.getMinX() < this.minX) {
            sprite.translateX(this.minX - sprite.getMinX());
        }
        if (this.maxX < sprite.getMaxX()) {
            sprite.translateX(this.maxX - sprite.getMaxX());
        }
        if (sprite.getMinY() < this.minY) {
            sprite.translateY(this.minY - sprite.getMinY());
        }
        if (this.maxY < sprite.getMaxY()) {
            sprite.translateY(this.maxY - sprite.getMaxY());
        }
    }
}

