/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Vector2D;
import fang2.core.Game;
import fang2.core.Sprite;
import fang2.transformers.BounceSpriteTransformer;
import fang2.transformers.VelocityProvider;
import fang2.transformers.VelocityTransformer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BounceClassTransformer
extends BounceSpriteTransformer {
    private final List<Sprite> spriteTargets;
    private final List<Class<? extends Sprite>> targetClasses = new ArrayList<Class<? extends Sprite>>();

    public BounceClassTransformer(Sprite sprite) {
        this(sprite, new VelocityTransformer(new Vector2D()));
    }

    public BounceClassTransformer(Sprite sprite, Class<? extends Sprite> clazz) {
        this(sprite, (VelocityProvider)new VelocityTransformer(new Vector2D()), clazz);
    }

    public BounceClassTransformer(Sprite sprite, VelocityProvider velocityProvider) {
        this(sprite, velocityProvider, (Class<? extends Sprite>)null);
    }

    public BounceClassTransformer(Sprite sprite, VelocityProvider velocityProvider, Class<? extends Sprite> clazz) {
        super(sprite, velocityProvider);
        this.spriteTargets = new ArrayList<Sprite>();
        if (clazz != null) {
            this.targetClasses.add(clazz);
        }
    }

    @Override
    public void add(Sprite sprite) {
        if (sprite != null && this.spriteTargets.indexOf(sprite) < 0) {
            this.spriteTargets.add(sprite);
        }
    }

    public void add(Class<? extends Sprite> clazz) {
        if (this.targetClasses.indexOf(clazz) < 0) {
            this.targetClasses.add(clazz);
        }
    }

    @Override
    public void advance(double d) {
        this.collectUpSprites();
        super.advance(d);
    }

    @Override
    public void remove(Sprite sprite) {
        this.spriteTargets.remove(sprite);
    }

    public void remove(Class<? extends Sprite> clazz) {
        this.targetClasses.remove(clazz);
    }

    private void collectUpSprites() {
        List<Sprite> list = this.getTargets();
        list.clear();
        list.addAll(this.spriteTargets);
        if (!this.targetClasses.isEmpty()) {
            Game game = Game.getCurrentGame();
            block0: for (Sprite sprite : game.getCanvas().getAllSprites()) {
                for (Class<? extends Sprite> clazz : this.targetClasses) {
                    if (!clazz.isInstance(sprite)) continue;
                    list.add(sprite);
                    continue block0;
                }
            }
        }
    }
}

