/*
 * Decompiled with CFR 0.152.
 */
package fang2.transformers;

import fang2.attributes.Location2D;
import fang2.attributes.Vector2D;
import fang2.core.Sprite;
import fang2.core.TransformerAdapter;
import fang2.transformers.VelocityProvider;
import fang2.transformers.VelocityTransformer;

public class AccelerationTransformer
extends TransformerAdapter
implements VelocityProvider {
    private Vector2D acceleration;
    private final VelocityProvider velocityNG;

    public AccelerationTransformer(Vector2D vector2D, VelocityProvider velocityProvider) {
        this.velocityNG = velocityProvider != null ? velocityProvider : new VelocityTransformer(new Vector2D());
        this.acceleration = vector2D;
    }

    public void advance(double d) {
        this.velocityNG.setVelocity(this.velocityNG.getVelocity().add(this.acceleration.multiply(d)));
        this.velocityNG.advance(d);
    }

    public Vector2D getAcceleration() {
        return this.acceleration;
    }

    public Vector2D getVelocity() {
        return this.velocityNG.getVelocity();
    }

    public void nonMaskableAdvance(double d) {
        this.velocityNG.nonMaskableAdvance(d);
    }

    public void setAcceleration(Vector2D vector2D) {
        this.acceleration = vector2D;
    }

    public void setVelocity(Location2D location2D) {
        this.velocityNG.setVelocity(location2D);
    }

    public void setVelocity(Vector2D vector2D) {
        this.velocityNG.setVelocity(vector2D);
    }

    public void updateSprite(Sprite sprite) {
        super.updateSprite(sprite);
        this.velocityNG.updateSprite(sprite);
    }
}

