/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.core.Sprite;
import fang2.sprites.PrettyStringSprite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StringSprite
extends Sprite {
    private static final double ADVANCE = 0.1;
    private static final Map<Font, Map<Character, PrettyStringSprite>> CACHE = new HashMap<Font, Map<Character, PrettyStringSprite>>();
    private static final double LEADING = 0.2;
    private static final double SPACE_WIDTH = 0.2;
    private static final double TAB_WIDTH = 2.5;
    private double baselineAngle = 0.0;
    private int deep = 0;
    private Font font = new Font(null, 0, 12);
    private double height;
    private final Point2D.Double justify = new Point2D.Double(0.0, 0.0);
    private boolean keepAspect = true;
    private Map<Character, PrettyStringSprite> letterRepository;
    private double maxCharacterWidth;
    private boolean monospaced = false;
    private String text = "";
    private boolean underlined = false;

    public StringSprite() {
        this("", 0.0, true);
    }

    public StringSprite(String string) {
        this(string, 0.0, true);
    }

    public StringSprite(String string, boolean bl) {
        this(string, 0.0, bl);
    }

    public StringSprite(String string, double d, boolean bl) {
        this.loadSampleLetters();
        this.setText(string);
        this.setScale(1.0);
        this.baselineAngle = d;
        this.setKeepAspect(bl);
    }

    public void bottomJustify() {
        this.justify.y = 1.0;
    }

    public void centerJustify() {
        this.justify.x = 0.0;
        this.justify.y = 0.0;
    }

    public boolean getAspect() {
        return this.keepAspect;
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontFamilyName() {
        return this.font.getFamily();
    }

    public double getHeight() {
        ++this.deep;
        double d = this.getScale() * this.getUnscaledHeight();
        --this.deep;
        return d;
    }

    public double getLineHeight() {
        ++this.deep;
        double d = this.height * this.getScale();
        --this.deep;
        return d;
    }

    public double getLineWidth(int n) throws IndexOutOfBoundsException {
        ++this.deep;
        double d = this.getScale() * this.getUnscaledLineWidth(n);
        --this.deep;
        return d;
    }

    public double getRotation() {
        ++this.deep;
        for (double d = super.getRotation() - this.baselineAngle; d < 0.0; d += Math.PI * 2) {
        }
        double d = super.getRotation();
        --this.deep;
        return d;
    }

    public double getScale() {
        if (this.deep > 0) {
            return super.getScale();
        }
        return this.getMaxDimension();
    }

    public Shape getShape() {
        ++this.deep;
        Rectangle2D.Double double_ = this.keepAspect ? new Rectangle2D.Double(0.0, 0.0, this.getUnscaledWidth(), this.getUnscaledHeight()) : new Rectangle2D.Double(0.0, 0.0, Math.max(this.getUnscaledWidth(), this.getUnscaledHeight()), Math.max(this.getUnscaledWidth(), this.getUnscaledHeight()));
        if (this.justify.x == 0.0) {
            double_.x = -double_.getCenterX();
        } else if (this.justify.x == 1.0) {
            double_.x = -double_.width;
        }
        if (this.justify.y == 0.0) {
            double_.y = -double_.getCenterY();
        } else if (this.justify.y == 1.0) {
            double_.y = -double_.height;
        }
        GeneralPath generalPath = new GeneralPath(double_);
        generalPath.transform(this.transform);
        --this.deep;
        return generalPath;
    }

    public String getText() {
        return this.text;
    }

    public double getWidth() {
        ++this.deep;
        double d = this.getScale() * this.getUnscaledWidth();
        --this.deep;
        return d;
    }

    public boolean isBold() {
        return this.font.isBold();
    }

    public boolean isItalic() {
        return this.font.isItalic();
    }

    @Deprecated
    public boolean isItalicized() {
        return this.isItalic();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void leftJustify() {
        this.justify.x = -1.0;
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(this.transform);
        if (!this.keepAspect) {
            graphics2D.transform(AffineTransform.getScaleInstance(this.getMaxDimension() / this.getWidth(), this.getMaxDimension() / this.getHeight()));
        }
        graphics2D.setColor(this.color);
        graphics2D.translate(0.0, -this.getUnscaledHeight() / 2.0 * (this.justify.y + 1.0) + this.height / 2.0);
        this.draw(graphics2D);
        graphics2D.setTransform(affineTransform);
        if (this.outline != null) {
            graphics2D.transform(this.transform);
            graphics2D.setColor(this.outlineColor);
            graphics2D.fill(this.outline);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void rightJustify() {
        this.justify.x = 1.0;
    }

    public void scale(double d) {
        if (this.deep > 0) {
            super.scale(d);
        } else {
            this.setMaxDimension(d * this.getMaxDimension());
        }
    }

    public void setBold(boolean bl) {
        if (this.font.isBold() == bl) {
            return;
        }
        this.font = bl ? this.font.deriveFont(this.font.getStyle() & 1) : this.font.deriveFont(this.font.getStyle() & 0xFFFFFFFE);
        this.loadSampleLetters();
    }

    public void setColor(Color color) {
        this.color = color;
        for (PrettyStringSprite prettyStringSprite : this.letterRepository.values()) {
            prettyStringSprite.setColor(color);
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.loadSampleLetters();
    }

    public void setFontFamilyName(String string) {
        if (string == this.font.getFamily() || string != null && this.font.getFamily() != null && string.equals(this.font.getFamily())) {
            return;
        }
        this.font = PrettyStringSprite.getFont(this.font.getStyle(), string);
        this.font = this.font.deriveFont(this.font.getSize());
        this.loadSampleLetters();
    }

    public void setHeight(double d) {
        if (this.getText().length() == 0) {
            this.setText(" ");
        }
        ++this.deep;
        this.setScale(d / (double)this.getText().split("\n").length);
        --this.deep;
    }

    public void setItalic(boolean bl) {
        if (this.font.isItalic() == bl) {
            return;
        }
        this.font = bl ? this.font.deriveFont(this.font.getStyle() & 2) : this.font.deriveFont(this.font.getStyle() & 0xFFFFFFFD);
        this.loadSampleLetters();
    }

    @Deprecated
    public void setItalicized(boolean bl) {
        this.setItalic(bl);
    }

    public void setKeepAspect(boolean bl) {
        this.keepAspect = bl;
    }

    public void setLineHeight(double d) {
        ++this.deep;
        this.setScale(d);
        --this.deep;
    }

    public void setMonospaced(boolean bl) {
        this.monospaced = bl;
    }

    public void setScale(double d) {
        if (this.deep > 0) {
            super.setScale(d);
        } else {
            this.setMaxDimension(d);
        }
    }

    public void setText(String string) {
        this.setText(string, this.keepAspect, this.underlined);
    }

    public void setText(String string, boolean bl) {
        this.setText(string, bl, this.underlined);
    }

    public void setText(String string, boolean bl, boolean bl2) {
        this.underlined = bl2;
        this.keepAspect = bl;
        this.text = string;
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
    }

    public void setWidth(double d) {
        String string = this.getText();
        if (this.getText().length() == 0) {
            this.setText(" ");
        }
        ++this.deep;
        this.scale(d / this.getWidth());
        this.setText(string);
        --this.deep;
    }

    public void showOutline() {
        this.shape = new GeneralPath(this.getShape());
        super.showOutline();
    }

    public void topJustify() {
        this.justify.y = -1.0;
    }

    public String toString() {
        return super.toString() + " text = \"" + this.getText() + "\"";
    }

    private void draw(Graphics2D graphics2D) {
        int n = 0;
        double d = -this.getUnscaledLineWidth(n) / 2.0 * (this.justify.x + 1.0);
        graphics2D.translate(d, 0.0);
        for (char c : this.text.toCharArray()) {
            if (c == '\n') {
                graphics2D.translate(-d, this.height + 0.2 * this.height);
                ++n;
                try {
                    d = -this.getUnscaledLineWidth(n) / 2.0 * (this.justify.x + 1.0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                graphics2D.translate(d, 0.0);
                continue;
            }
            if (c == '\t') {
                double d2 = 2.5;
                if (this.monospaced) {
                    d2 = Math.round(d2);
                }
                graphics2D.transform(AffineTransform.getTranslateInstance((this.maxCharacterWidth + this.maxCharacterWidth * 0.1) * d2, 0.0));
                d += (this.maxCharacterWidth + this.maxCharacterWidth * 0.1) * d2;
                continue;
            }
            if (c == ' ') {
                double d3 = 0.2;
                if (this.monospaced) {
                    d3 = 1.0;
                }
                graphics2D.transform(AffineTransform.getTranslateInstance(this.maxCharacterWidth * 0.1 + this.maxCharacterWidth * d3, 0.0));
                d += this.maxCharacterWidth * 0.1 + this.maxCharacterWidth * d3;
                continue;
            }
            d = this.monospaced ? (d += this.maxCharacterWidth) : (d += this.getSprite(c).getWidth());
            d += this.maxCharacterWidth * 0.1;
            if (this.monospaced) {
                graphics2D.translate(this.maxCharacterWidth / 2.0, 0.0);
            } else {
                graphics2D.translate(this.getSprite(c).getWidth() / 2.0, 0.0);
            }
            if (this.underlined) {
                double d4 = this.maxCharacterWidth * 0.1;
                d4 = this.monospaced ? (d4 += this.maxCharacterWidth) : (d4 += this.getSprite(c).getWidth());
                Rectangle2D.Double double_ = new Rectangle2D.Double(-d4 / 2.0, 0.4166666666666667, d4, 0.08333333333333333);
                graphics2D.fill(double_);
            }
            this.getSprite(c).setColor(this.color);
            this.getSprite(c).paint(graphics2D);
            if (this.monospaced) {
                graphics2D.translate(this.maxCharacterWidth / 2.0, 0.0);
            } else {
                graphics2D.translate(this.getSprite(c).getWidth() / 2.0, 0.0);
            }
            graphics2D.translate(this.maxCharacterWidth * 0.1, 0.0);
        }
    }

    private double getMaxDimension() {
        ++this.deep;
        double d = Math.max(this.getWidth(), this.getHeight());
        --this.deep;
        return d;
    }

    private PrettyStringSprite getSprite(char c) {
        if (!this.letterRepository.containsKey(Character.valueOf(c))) {
            PrettyStringSprite prettyStringSprite = new PrettyStringSprite("" + c, true);
            prettyStringSprite.setFont(this.font.getFamily());
            prettyStringSprite.setBold(this.font.isBold());
            prettyStringSprite.setItalicized(this.font.isItalic());
            prettyStringSprite.setHeight(1.0);
            prettyStringSprite.setColor(this.color);
            this.height = prettyStringSprite.getHeight();
            this.letterRepository.put(Character.valueOf(c), prettyStringSprite);
        }
        return this.letterRepository.get(Character.valueOf(c));
    }

    private double getUnscaledHeight() {
        return this.height * 1.2 * (double)this.text.split("\n").length - 0.2 * this.height;
    }

    private double getUnscaledLineWidth(int n) throws IndexOutOfBoundsException {
        String[] stringArray = this.text.split("\n");
        if (n < 0 || n >= stringArray.length) {
            throw new IndexOutOfBoundsException();
        }
        String string = this.text.split("\n")[n];
        double d = -0.1 * this.maxCharacterWidth;
        for (char c : string.toCharArray()) {
            if (c == '\t') {
                if (this.monospaced) {
                    d += (double)Math.round(2.5) * (this.maxCharacterWidth + 0.1 * this.maxCharacterWidth);
                    continue;
                }
                d += 2.5 * (this.maxCharacterWidth + 0.1 * this.maxCharacterWidth);
                continue;
            }
            if (c == ' ') {
                if (this.monospaced) {
                    d += this.maxCharacterWidth + 0.1 * this.maxCharacterWidth;
                    continue;
                }
                d += 0.2 * this.maxCharacterWidth + 0.1 * this.maxCharacterWidth;
                continue;
            }
            if (this.monospaced) {
                d += this.maxCharacterWidth + 0.1 * this.maxCharacterWidth;
                continue;
            }
            d += this.getSprite(c).getWidth() + 0.1 * this.maxCharacterWidth;
        }
        return d;
    }

    private double getUnscaledWidth() {
        double d = this.getUnscaledLineWidth(0);
        for (int i = 1; i < this.text.split("\n").length; ++i) {
            d = Math.max(d, this.getUnscaledLineWidth(i));
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSampleLetters() {
        Map<Font, Map<Character, PrettyStringSprite>> map = CACHE;
        synchronized (map) {
            if (CACHE.containsKey(this.font)) {
                this.letterRepository = CACHE.get(this.font);
            } else {
                this.letterRepository = Collections.synchronizedMap(new HashMap());
                for (int i = 0; i < 26; ++i) {
                    this.getSprite((char)(65 + i));
                    this.getSprite((char)(97 + i));
                    if (i >= 10) continue;
                    this.getSprite((char)(48 + i));
                }
                CACHE.put(this.font, this.letterRepository);
            }
            for (PrettyStringSprite prettyStringSprite : this.letterRepository.values().toArray(new PrettyStringSprite[0])) {
                this.maxCharacterWidth = Math.max(this.maxCharacterWidth, prettyStringSprite.getWidth());
                this.height = prettyStringSprite.getHeight();
            }
        }
    }

    private void setMaxDimension(double d) {
        ++this.deep;
        this.scale(d / this.getMaxDimension());
        --this.deep;
    }
}

