/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Box2D;
import fang2.attributes.Location2D;
import fang2.core.Sprite;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.URL;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyStringSprite
extends Sprite {
    private boolean keepAspect;
    private boolean underline = false;
    private int fontStyle = 0;
    private String style = null;
    private static HashMap<String, Font> customFonts = new HashMap();
    private static HashMap<String, Font> availableFonts = PrettyStringSprite.getAvailableFonts();
    private static HashMap<String, Rectangle2D> fontSize = new HashMap();
    private static final double MARGIN = 0.05;
    private double baseRotation;
    private double originalSize = 1.0;
    private final Point justify = new Point();
    private String text;

    public PrettyStringSprite(String string) {
        this(string, true);
        this.keepAspect = true;
    }

    private static HashMap<String, Font> getAvailableFonts() {
        HashMap<String, Font> hashMap = new HashMap<String, Font>();
        for (String string : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            hashMap.put(string, null);
        }
        return hashMap;
    }

    public PrettyStringSprite(String string, boolean bl) {
        this.setText(string, bl);
        this.setScale(1.0);
    }

    public PrettyStringSprite(String string, boolean bl, double d) {
        this.baseRotation = d;
        this.setText(string, bl);
        this.setScale(1.0);
    }

    public void setLineHeight(double d) {
        this.setScale(d * this.originalSize);
    }

    public void setHeight(double d) {
        this.setScale(d * this.originalSize / (double)this.text.split("\n").length);
    }

    @Override
    public void setScale(double d) {
        if (d == this.getScale()) {
            return;
        }
        Location2D location2D = this.getLocation();
        super.setScale(d);
        this.setLocation((Point2D.Double)location2D);
    }

    public boolean isItalic() {
        return (this.fontStyle & 2) != 0;
    }

    public void setItalicized(boolean bl) {
        if (this.isItalicized() == bl) {
            return;
        }
        this.fontStyle |= 2;
        double d = this.getLineHeight();
        this.updateText();
        this.setHeight(d);
    }

    public void setBold(boolean bl) {
        if (this.isBold() == bl) {
            return;
        }
        this.fontStyle |= 1;
        double d = this.getLineHeight();
        this.updateText();
        this.setHeight(d);
    }

    @Deprecated
    public boolean isItalicized() {
        return (this.fontStyle & 2) != 0;
    }

    public boolean isBold() {
        return (this.fontStyle & 1) != 0;
    }

    public void leftJustify() {
        if (this.justify.x == -1) {
            return;
        }
        if (this.justify.x == 0) {
            this.translate(this.getWidth() / 2.0, 0.0);
        } else if (this.justify.x == 1) {
            this.translate(this.getWidth(), 0.0);
        }
        this.justify.x = -1;
        if (this.text.split("\n").length > 1) {
            double d = this.getLineHeight();
            this.updateText();
            this.setHeight(d);
        }
    }

    public void topJustify() {
        if (this.justify.y == -1) {
            return;
        }
        if (this.justify.y == 0) {
            this.translate(0.0, this.getHeight() / 2.0);
        } else if (this.justify.y == 1) {
            this.translate(0.0, this.getHeight());
        }
        this.justify.y = -1;
    }

    public void bottomJustify() {
        if (this.justify.y == 1) {
            return;
        }
        if (this.justify.y == 0) {
            this.translate(0.0, -this.getHeight() / 2.0);
        } else if (this.justify.y == -1) {
            this.translate(0.0, -this.getHeight());
        }
        this.justify.y = 1;
    }

    public void rightJustify() {
        if (this.justify.x == 1) {
            return;
        }
        if (this.justify.x == 0) {
            this.translate(-this.getWidth() / 2.0, 0.0);
        } else if (this.justify.x == -1) {
            this.translate(-this.getWidth(), 0.0);
        }
        this.justify.x = 1;
        if (this.text.split("\n").length > 1) {
            double d = this.getLineHeight();
            this.updateText();
            this.setHeight(d);
        }
    }

    public void centerJustify() {
        if (this.justify.x == -1) {
            this.translate(this.getWidth() / 2.0, 0.0);
            if (this.text.split("\n").length > 1) {
                this.updateText();
            }
        } else if (this.justify.x == 1) {
            this.translate(this.getWidth() / 2.0, 0.0);
            if (this.text.split("\n").length > 1) {
                this.updateText();
            }
        }
        this.justify.x = 0;
        if (this.justify.y == -1) {
            this.translate(0.0, this.getHeight() / 2.0);
        } else if (this.justify.y == 1) {
            this.translate(0.0, this.getHeight() / 2.0);
        }
        this.justify.y = 0;
    }

    public void setUnderlined(boolean bl) {
        if (this.underline == bl) {
            return;
        }
        this.underline = bl;
        this.updateText();
    }

    public String getFontFamilyName() {
        return this.style;
    }

    public void setFont(Font font) {
        availableFonts.put(font.getFamily(), font);
        this.setFont(font.getFamily());
    }

    public void setFont(String string) {
        if (string == this.style || this.style != null && string != null && this.style.equals(string)) {
            return;
        }
        this.style = string;
        double d = this.getLineHeight();
        this.updateText();
        this.setHeight(d);
    }

    public void setKeepAspect(boolean bl) {
        this.setText(this.text, bl);
    }

    public void setMonospaced(boolean bl) {
        if (bl) {
            this.setFont(new Font("Monospaced", 0, 12));
        } else {
            this.setFont(new Font("SansSerif", 0, 12));
        }
    }

    @Deprecated
    public void setFontFamilyName(String string) {
        this.setFont(string);
    }

    public boolean isUnderlined() {
        return this.underline;
    }

    @Override
    protected void normalize() {
    }

    public double getLineHeight() {
        return this.getScale() / this.originalSize;
    }

    @Override
    public void translate(double d, double d2) {
        Location2D location2D = this.getLocation();
        this.setLocation(location2D.x + d, location2D.y + d2);
    }

    @Override
    public void setLocation(double d, double d2) {
        super.setLocation(d - (double)this.justify.x * this.getWidth() / 2.0, d2 - (double)this.justify.y * this.getHeight() / 2.0);
    }

    @Override
    public Location2D getLocation() {
        Location2D location2D = super.getLocation();
        location2D.x += (double)this.justify.x * this.getWidth() / 2.0;
        location2D.y += (double)this.justify.y * this.getHeight() / 2.0;
        return location2D;
    }

    @Override
    public double getWidth() {
        double d = this.getRotation();
        this.setRotation(0.0);
        double d2 = this.getShape().getBounds2D().getWidth();
        this.setRotation(d);
        return d2;
    }

    @Override
    public Box2D getBounds2D() {
        Location2D location2D = this.getLocation();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.justify.x == -1 ? location2D.x : (this.justify.x == 0 ? location2D.x - d / 2.0 : location2D.x - d);
        double d4 = this.justify.y == -1 ? location2D.y : (this.justify.y == 0 ? location2D.y - d2 / 2.0 : location2D.y - d2);
        return new Box2D(d3, d4, d, d2);
    }

    @Override
    public double getHeight() {
        return this.getLineHeight() * (double)this.text.split("\n").length;
    }

    public void setWidth(double d) {
        this.scale(d / this.getWidth());
    }

    public static Font getFont(int n, String string) {
        if (string == null) {
            return new Font(null, n, 12);
        }
        if (availableFonts.containsKey(string)) {
            if (availableFonts.get(string) == null) {
                availableFonts.put(string, new Font(string, n, 12));
            }
            return availableFonts.get(string).deriveFont(n);
        }
        if (customFonts.containsKey(string)) {
            return customFonts.get(string).deriveFont(n);
        }
        URL uRL = PrettyStringSprite.class.getResource("resources/" + string + ".ttf");
        try {
            Font font = Font.createFont(0, uRL.openStream());
            if (!font.getFamily().equals(string)) {
                System.err.println("Must match font file with font name\nFont file: fang2/resources/" + string + ".ttf\n" + "Font name: fang2/resources/" + font.getFamily() + "\n" + "Please rename fang2/resources/" + string + ".ttf to " + "fang2/resources/" + font.getFamily() + ".ttf");
            }
            customFonts.put(string, font);
            return font.deriveFont(n);
        }
        catch (Exception exception) {
            System.err.println("Font family " + string + " not found.\n" + "Put " + string + ".ttf in fang2/resources package.\n" + "Also check for spelling and case sensitivity errors.");
            return new Font(null, n, 12);
        }
    }

    private Font getFont(int n) {
        return PrettyStringSprite.getFont(n, this.style);
    }

    private void updateText() {
        double d;
        Shape shape;
        Font font;
        Rectangle2D.Double double_;
        Cloneable cloneable;
        if (this.text.length() == 0) {
            this.setShape(new GeneralPath());
            this.originalSize = 1.0;
        }
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        String[] stringArray = this.text.split("\n");
        if (fontSize.containsKey(this.style)) {
            cloneable = fontSize.get(this.style);
            double_ = new Rectangle2D.Double(((RectangularShape)cloneable).getMinX(), ((RectangularShape)cloneable).getMinY(), ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight());
        } else {
            font = this.getFont(0);
            cloneable = font.createGlyphVector(new FontRenderContext(null, false, true), "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
            GeneralPath generalPath = new GeneralPath(((GlyphVector)cloneable).getOutline());
            shape = generalPath.getBounds2D();
            fontSize.put(this.style, (Rectangle2D)shape);
            double_ = new Rectangle2D.Double(((RectangularShape)shape).getMinX(), ((RectangularShape)shape).getMinY(), ((RectangularShape)shape).getWidth(), ((RectangularShape)shape).getHeight());
        }
        double d4 = -double_.getMinY();
        ((Rectangle2D)double_).setRect(double_.getMinX(), double_.getMinY() + d4, ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        shape = new Area();
        double d5 = 0.05;
        font = this.getFont(this.fontStyle);
        for (String string : stringArray) {
            GlyphVector glyphVector = font.createGlyphVector(new FontRenderContext(null, false, true), string);
            GeneralPath generalPath = new GeneralPath(glyphVector.getOutline());
            generalPath.transform(AffineTransform.getTranslateInstance(0.0, d4));
            Rectangle2D rectangle2D = generalPath.getBounds2D();
            if (this.underline) {
                d = double_.getMaxY() - ((RectangularShape)double_).getHeight() / 12.0;
                Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, d, rectangle2D.getWidth(), ((RectangularShape)double_).getHeight() / 12.0);
                Area area = new Area(generalPath);
                area.add(new Area(double_2));
                generalPath = new GeneralPath(area);
            }
            if (this.justify.x == 0) {
                generalPath.transform(AffineTransform.getTranslateInstance(-generalPath.getBounds2D().getCenterX(), d5));
            }
            if (this.justify.x == -1) {
                generalPath.transform(AffineTransform.getTranslateInstance(-generalPath.getBounds2D().getMinX(), d5));
            }
            if (this.justify.x == 1) {
                generalPath.transform(AffineTransform.getTranslateInstance(-generalPath.getBounds2D().getMaxX(), d5));
            }
            ((Area)shape).add(new Area(generalPath));
            d5 += ((RectangularShape)double_).getHeight() + 0.1;
        }
        double d6 = (double)stringArray.length * (((RectangularShape)double_).getHeight() + 0.1);
        ((Area)shape).transform(AffineTransform.getTranslateInstance(-((Area)shape).getBounds2D().getCenterX(), -d6 / 2.0));
        ((Area)shape).transform(AffineTransform.getScaleInstance(1.0 / (((RectangularShape)double_).getHeight() + 0.1), 1.0 / (((RectangularShape)double_).getHeight() + 0.1)));
        this.originalSize = Math.max(((Area)shape).getBounds2D().getWidth(), ((Area)shape).getBounds2D().getHeight());
        if (this.originalSize <= 0.0) {
            this.originalSize = 1.0;
        }
        ((Area)shape).transform(AffineTransform.getScaleInstance(1.0 / this.originalSize, 1.0 / this.originalSize));
        if (!this.keepAspect) {
            double d7 = Math.min(((Area)shape).getBounds2D().getWidth(), ((Area)shape).getBounds2D().getHeight());
            if (d7 == ((Area)shape).getBounds2D().getHeight()) {
                ((Area)shape).transform(AffineTransform.getScaleInstance(1.0, 1.0 / d7));
            } else {
                ((Area)shape).transform(AffineTransform.getScaleInstance(1.0 / d7, 1.0));
            }
        }
        this.setShape(shape);
        double d8 = this.getWidth();
        double d9 = this.getHeight();
        d = d8 - d2;
        double d10 = d9 - d3;
        this.translate((double)(-this.justify.x) * d / 2.0, (double)(-this.justify.y) * d10 / 2.0);
    }

    public void setText(String string, boolean bl, boolean bl2) {
        if (this.text != null && this.text.equals(string) && bl == this.keepAspect && this.underline == bl2) {
            return;
        }
        this.underline = bl2;
        this.keepAspect = bl;
        this.text = string;
        double d = this.getLineHeight();
        this.updateText();
        this.setLineHeight(d);
    }

    public void setText(String string, boolean bl) {
        this.setText(string, bl, this.underline);
    }

    public void setText(String string) {
        this.setText(string, this.keepAspect, this.underline);
    }

    @Override
    public double getRotation() {
        for (double d = super.getRotation() - this.baseRotation; d < 0.0; d += Math.PI * 2) {
        }
        return super.getRotation();
    }

    public String getText() {
        return this.text;
    }

    public Shape getRotatedBoundingBox() {
        double d = this.getRotation();
        this.setRotation(0.0);
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        this.setRotation(d);
        GeneralPath generalPath = new GeneralPath(rectangle2D);
        generalPath.transform(AffineTransform.getRotateInstance(d, rectangle2D.getCenterX(), rectangle2D.getCenterY()));
        return generalPath;
    }

    public boolean getAspect() {
        return this.keepAspect;
    }

    @Override
    public String toString() {
        return super.toString() + " text = \"" + this.getText() + "\"";
    }
}

