/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Location2D;
import fang2.core.Sprite;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class PolyLineSprite
extends Sprite {
    public static final double DEFAULT_LINE_THICKNESS = 0.01;
    private static double INITIAL_LINE_THICKNESS = 0.01;
    public static final double MINIMUM_LINE_THICKNESS = 0.001;
    protected GeneralPath lines;
    private double lineWidth = INITIAL_LINE_THICKNESS;
    protected BasicStroke stroke = new BasicStroke((float)this.lineWidth);

    public PolyLineSprite() {
        this(0.0, 0.0, 1.0, 1.0);
    }

    public PolyLineSprite(double ... dArray) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        int n = 0;
        while (n + 1 < dArray.length) {
            arrayList.add(new Point2D.Double(dArray[n], dArray[n + 1]));
            n += 2;
        }
        this.initPath(arrayList.toArray(new Point2D.Double[0]));
    }

    public PolyLineSprite(int n) {
        this(PolyLineSprite.makePolygonPoints(n));
    }

    public PolyLineSprite(Location2D ... location2DArray) {
        this((Point2D.Double[])location2DArray);
    }

    public PolyLineSprite(Point2D.Double ... doubleArray) {
        this.initPath(doubleArray);
    }

    public PolyLineSprite(Shape shape) {
        this.lines = new GeneralPath(shape);
        this.initShape(true);
    }

    public PolyLineSprite(Sprite sprite) {
        this(sprite.getShape());
    }

    public static double getInitialLineThickness() {
        return INITIAL_LINE_THICKNESS;
    }

    public static Location2D[] makePolygonPoints(int n) {
        if (n < 3) {
            n = 3;
        }
        double d = -1.5707963267948966;
        Location2D[] location2DArray = new Location2D[n + 1];
        location2DArray[0] = new Location2D(Math.cos(d) * 0.5, Math.sin(d) * 0.5);
        location2DArray[n] = new Location2D(Math.cos(d) * 0.5, Math.sin(d) * 0.5);
        for (int i = 1; i < n; ++i) {
            d = -1.5707963267948966 + (double)(i * 2) * Math.PI / (double)n;
            location2DArray[i] = new Location2D(Math.cos(d) * 0.5, Math.sin(d) * 0.5);
        }
        return location2DArray;
    }

    public static void setInitialLineThickness(double d) {
        INITIAL_LINE_THICKNESS = Math.max(0.001, d);
    }

    public double getLineDashLength() {
        float[] fArray = this.stroke.getDashArray();
        if (fArray.length == 0) {
            return 0.0;
        }
        return fArray[0];
    }

    public float[] getLineDashPattern() {
        float[] fArray = this.stroke.getDashArray();
        return fArray;
    }

    public double getLineThickness() {
        return this.lineWidth;
    }

    public boolean hasBevelJoin() {
        return this.stroke.getLineJoin() == 2;
    }

    public boolean hasButtCap() {
        return this.stroke.getEndCap() == 0;
    }

    public boolean hasMiterJoin() {
        return this.stroke.getLineJoin() == 0;
    }

    public boolean hasRoundCap() {
        return this.stroke.getEndCap() == 1;
    }

    public boolean hasRoundJoin() {
        return this.stroke.getLineJoin() == 1;
    }

    public boolean hasSquareCap() {
        return this.stroke.getEndCap() == 2;
    }

    protected void initPath(Point2D.Double ... doubleArray) {
        this.lines = new GeneralPath();
        this.lines.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        for (int i = 1; i < doubleArray.length; ++i) {
            this.lines.lineTo((float)doubleArray[i].x, (float)doubleArray[i].y);
        }
        this.initShape(true);
    }

    protected void initShape(boolean bl) {
        this.stroke = new BasicStroke((float)this.lineWidth, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), 0.0f);
        if (bl) {
            this.setAbsoluteShape(this.stroke.createStrokedShape(this.lines));
        } else {
            this.setShape(this.stroke.createStrokedShape(this.lines));
        }
    }

    public void setLineDashLength(double d) {
        float[] fArray = new float[]{(float)d, (float)d};
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), fArray, this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void setLineDashPattern(float ... fArray) {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), fArray, this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void setLineThickness(double d) {
        this.lineWidth = (float)Math.max(0.001, d);
        this.initShape(false);
    }

    public void useBevelJoin() {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), 2, this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void useButtCap() {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), 0, this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void useMiterJoin() {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), 0, this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void useRoundCap() {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), 1, this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void useRoundJoin() {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), 1, this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }

    public void useSquareCap() {
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), 2, this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.setShape(this.stroke.createStrokedShape(this.lines));
    }
}

