/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Location2D;
import fang2.core.Sprite;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class OutlineSprite
extends Sprite {
    private static final double DEFAULT_FLATNESS = 0.001;
    private static double INITIAL_LINE_THICKNESS = 0.01;
    private double lineThickness = INITIAL_LINE_THICKNESS;
    private Shape startingShape;

    public static double getInitialLineThickness() {
        return INITIAL_LINE_THICKNESS;
    }

    public static void setInitialLineThickness(double d) {
        INITIAL_LINE_THICKNESS = Math.max(0.001, d);
    }

    public OutlineSprite(double ... dArray) {
        this.startingShape = this.getPath(dArray);
        this.initShape();
    }

    public OutlineSprite(Location2D ... location2DArray) {
        this.startingShape = this.getPath(location2DArray);
        this.initShape();
    }

    public OutlineSprite(Point2D.Double ... doubleArray) {
        this.startingShape = this.getPath(doubleArray);
        this.initShape();
    }

    public OutlineSprite(Shape shape) {
        this.startingShape = new Area(shape);
        this.initShape();
    }

    public OutlineSprite(Sprite sprite) {
        this.startingShape = sprite.getShape();
        this.initShape();
    }

    public double getLineThickness() {
        return this.lineThickness;
    }

    public void initShape() {
        Shape shape = this.startingShape;
        Point2D.Double double_ = new Point2D.Double();
        double d = 1.0;
        this.lineThickness /= d;
        this.startingShape = shape;
        Shape shape2 = this.getOutline(shape);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        this.setShape(shape2);
        this.setScale(Math.max(rectangle2D.getWidth(), rectangle2D.getHeight()));
        this.setLocation(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        this.scale(d);
        this.translate(double_);
        this.lineThickness *= d;
    }

    public void setLineThickness(double d) {
        this.lineThickness = Math.max(0.001, d);
        this.initShape();
    }

    private Area getLine(double d, double d2, double d3, double d4) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D.Double double_2 = new Point2D.Double(d3, d4);
        Point2D.Double double_3 = new Point2D.Double((double_.x + double_2.x) / 2.0, (double_.y + double_2.y) / 2.0);
        double d5 = Math.atan2(double_2.y - double_.y, double_2.x - double_.x);
        double d6 = double_.distance(double_2);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(0.0, 0.0, d6, this.lineThickness);
        Ellipse2D.Double double_5 = new Ellipse2D.Double(-this.lineThickness / 2.0, 0.0, this.lineThickness, this.lineThickness);
        Ellipse2D.Double double_6 = new Ellipse2D.Double(d6 - this.lineThickness / 2.0, 0.0, this.lineThickness, this.lineThickness);
        Area area = new Area(double_4);
        area.add(new Area(double_5));
        area.add(new Area(double_6));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(double_3.x, double_3.y);
        affineTransform.rotate(d5);
        affineTransform.translate(-d6 / 2.0, -this.lineThickness / 2.0);
        area.transform(affineTransform);
        return area;
    }

    private Shape getOutline(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform(), 0.001);
        double[] dArray = new double[6];
        pathIterator.currentSegment(dArray);
        Point2D.Double double_ = new Point2D.Double();
        double_.x = dArray[0];
        double_.y = dArray[1];
        Point2D.Double double_2 = new Point2D.Double();
        double_2.x = dArray[0];
        double_2.y = dArray[1];
        pathIterator.next();
        Area area = new Area();
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 4) {
                dArray[0] = double_2.x;
                dArray[1] = double_2.y;
                n = 1;
            } else if (n == 0) {
                double_2.x = dArray[0];
                double_2.y = dArray[1];
            }
            if (n == 1) {
                Area area2 = this.getLine(double_.x, double_.y, dArray[0], dArray[1]);
                area.add(area2);
            }
            double_.x = dArray[0];
            double_.y = dArray[1];
            pathIterator.next();
        }
        return area;
    }

    private Shape getPath(double ... dArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
        for (int i = 2; i < dArray.length - 1; i += 2) {
            generalPath.lineTo((float)dArray[i], (float)dArray[i + 1]);
        }
        return generalPath;
    }

    private Shape getPath(Point2D.Double ... doubleArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        for (int i = 1; i < doubleArray.length; ++i) {
            generalPath.lineTo((float)doubleArray[i].x, (float)doubleArray[i].y);
        }
        return generalPath;
    }
}

