/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Location2D;
import fang2.attributes.Palette;
import fang2.core.Game;
import fang2.core.Sprite;
import fang2.sprites.CompositeSprite;
import fang2.sprites.InputStringSprite;
import fang2.sprites.RectangleSprite;
import fang2.sprites.StringSprite;
import java.util.ArrayList;

public class InputStringField
extends CompositeSprite {
    private final RectangleSprite box;
    private final RectangleSprite deactivated;
    private final InputStringSprite input;
    private final StringSprite label;
    private final double used = 0.9;
    private final ArrayList<Integer> players = new ArrayList();
    private boolean disregardMouse = true;

    public InputStringField(double d, double d2) {
        this(d, d2, 0);
    }

    public InputStringField(double d, double d2, int ... nArray) {
        for (int n : nArray) {
            this.players.add(n);
        }
        double d3 = Math.max(d, d2);
        this.box = new RectangleSprite(d / d3, d2 / d3);
        this.box.setColor(Game.getColor("white"));
        this.deactivated = new RectangleSprite(d / d3, d2 / d3);
        this.deactivated.setColor(Palette.getColor("Gray", 64));
        this.deactivated.setVisible(false);
        this.input = new InputStringSprite();
        this.input.setLineHeight(this.box.getHeight() * 0.9);
        this.input.setLocation(-this.box.getWidth() / 2.0 * 0.9, -this.box.getHeight() / 2.0 * 0.9);
        this.label = new StringSprite();
        this.label.setLineHeight(this.box.getHeight() * 0.9 * 0.5);
        this.label.setLocation(-this.box.getWidth() / 2.0, -this.box.getHeight() / 2.0);
        this.label.leftJustify();
        this.label.bottomJustify();
        this.addSprite((Sprite)this.label);
        this.addSprite((Sprite)this.box);
        this.addSprite((Sprite)this.deactivated);
        this.addSprite((Sprite)this.input);
        this.setSize(d3);
    }

    public void requireMouseOver(boolean bl) {
        this.disregardMouse = !bl;
    }

    public void setLabelText(String string) {
        this.label.setText(string);
    }

    public String getLabelText() {
        return this.label.getText();
    }

    public void showLabel() {
        this.setLabelVisible(true);
    }

    public void hideLabel() {
        this.setLabelVisible(false);
    }

    public void setLabelVisible(boolean bl) {
        this.label.setVisible(false);
    }

    public boolean hasEnteredText() {
        return this.getText().contains("\n");
    }

    public String getEnteredText() {
        if (!this.hasEnteredText()) {
            return null;
        }
        return this.getText().split("\n")[0];
    }

    public String getText() {
        return this.input.getText();
    }

    public void setText(String string) {
        this.input.setText(string);
    }

    public void addPlayerInput(int ... nArray) {
        for (int n : nArray) {
            if (this.players.contains(n)) continue;
            this.players.add(n);
        }
    }

    public void removePlayerInput(int ... nArray) {
        for (int n : nArray) {
            if (!this.players.contains(n)) continue;
            this.players.remove(n);
        }
    }

    public void clearPlayerInput() {
        this.players.clear();
    }

    public boolean canInput(int n) {
        return this.players.contains(n);
    }

    public void update() {
        int n2;
        this.input.clearPlayerInput();
        this.deactivated.setVisible(true);
        for (int n2 : this.players) {
            boolean bl;
            Location2D location2D = Game.getCurrentGame().getMouse2D(n2);
            boolean bl2 = bl = this.disregardMouse || this.intersects(location2D);
            if (bl) {
                this.input.addPlayerInput(n2);
                this.deactivated.setVisible(false);
                continue;
            }
            this.input.removePlayerInput(n2);
        }
        this.input.update();
        boolean bl = this.input.getWidth() > this.box.getWidth() * 0.9 || this.input.getHeight() > this.box.getHeight() * 0.9;
        int n3 = n2 = this.input.getHeight() < this.box.getHeight() * 0.9 ? 1 : 0;
        while (!bl && n2 != 0) {
            this.input.setLineHeight(this.input.getLineHeight() + 0.0025);
            bl = this.input.getWidth() > this.box.getWidth() * 0.9 || this.input.getHeight() > this.box.getHeight() * 0.9;
            n2 = this.input.getHeight() < this.box.getHeight() * 0.9 ? 1 : 0;
        }
        while (bl) {
            this.input.setLineHeight(this.input.getLineHeight() - 0.0025);
            bl = this.input.getWidth() > this.box.getWidth() * 0.9 || this.input.getHeight() > this.box.getHeight() * 0.9;
        }
    }
}

