/*
 * Decompiled with CFR 0.152.
 */
package fang2.sprites;

import fang2.attributes.Location2D;
import fang2.core.Alarm;
import fang2.core.AlarmAdapter;
import fang2.core.GameLoop;
import fang2.core.Mouse;
import fang2.core.Sprite;
import fang2.sprites.CompositeSprite;
import fang2.sprites.PrettyStringSprite;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class ButtonSprite
extends CompositeSprite {
    private final PrettyStringSprite text;
    private Sprite top;
    private Sprite bottom;
    private ArrayList<Mouse> mouse;
    private ArrayList<Alarm> alarm;
    private ArrayList<ActionListener> action;
    private Color foreground;
    private Color background;
    private double aspect;
    private static final Color DEFAULT_FOREGROUND = Color.YELLOW;
    private static final Color DEFAULT_BACKGROUND = new Color(92, 0, 0);
    private static final double MAX_HEIGHT = 0.7;
    private static final double MAX_WIDTH = 0.8;
    private static final double ASPECT_PADDING = 1.2;

    public ButtonSprite(String string) {
        this.text = new PrettyStringSprite(string, true);
        double d = this.text.getWidth() / this.text.getHeight();
        d = string.trim().length() > 0 ? (d *= 1.2) : 1.0;
        this.initialize(string, d);
    }

    public ButtonSprite(String string, double d) {
        this.text = new PrettyStringSprite(string, true);
        this.initialize(string, d);
    }

    private void initialize(String string, double d) {
        this.alarm = new ArrayList();
        this.mouse = new ArrayList();
        this.aspect = d;
        this.action = new ArrayList();
        this.foreground = DEFAULT_FOREGROUND;
        this.background = DEFAULT_BACKGROUND;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, 1.0, 1.0, 1.0);
        this.top = new Sprite(double_);
        this.top.setScale(1.0);
        this.bottom = new Sprite(double_);
        this.bottom.setScale(1.0);
        Location2D location2D = this.top.getLocation();
        location2D.y += 0.025;
        location2D.x += 0.025;
        this.bottom.setLocation((Point2D.Double)location2D);
        this.setTextSize();
        this.addSprite(this.bottom);
        this.addSprite(this.top);
        this.addSprite((Sprite)this.text);
        this.raise();
    }

    private void setTextSize() {
        this.text.setLineHeight(0.8 / this.aspect);
        if (this.text.getWidth() > 0.8) {
            this.text.setWidth(0.8);
        }
        if (this.text.getHeight() > 0.7) {
            this.text.setLineHeight(0.7);
        }
    }

    public void raise() {
        this.top.setColor(this.background);
        this.bottom.setColor(this.foreground);
        this.text.setColor(this.foreground);
    }

    public void lower() {
        this.top.setColor(this.foreground);
        this.bottom.setColor(this.background);
        this.text.setColor(this.background);
    }

    public void setTextColor(Color color) {
        this.foreground = color;
    }

    public void setButtonColor(Color color) {
        this.background = color;
    }

    public void executePressAction() {
        for (Alarm object : this.alarm) {
            object.act();
        }
        for (ActionListener actionListener : this.action) {
            actionListener.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public void addAlarm(Alarm ... alarmArray) {
        for (Alarm alarm : alarmArray) {
            this.alarm.add(alarm);
        }
    }

    public void removeAlarm(Alarm ... alarmArray) {
        for (Alarm alarm : alarmArray) {
            this.alarm.remove(alarm);
        }
    }

    public void addTimedAction(AlarmAdapter ... alarmAdapterArray) {
        for (AlarmAdapter alarmAdapter : alarmAdapterArray) {
            this.alarm.add(alarmAdapter);
        }
    }

    public void removeTimedAction(AlarmAdapter ... alarmAdapterArray) {
        for (AlarmAdapter alarmAdapter : alarmAdapterArray) {
            this.alarm.remove(alarmAdapter);
        }
    }

    public void addActionListener(ActionListener ... actionListenerArray) {
        for (ActionListener actionListener : actionListenerArray) {
            this.action.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener ... actionListenerArray) {
        for (ActionListener actionListener : actionListenerArray) {
            this.action.remove(actionListener);
        }
    }

    public void enable(GameLoop gameLoop) {
        for (int i = 0; i < gameLoop.getNumberOfPlayers(); ++i) {
            this.mouse.add(gameLoop.getPlayer(i).getMouse());
        }
    }

    public void enable(Mouse ... mouseArray) {
        for (Mouse mouse : mouseArray) {
            this.mouse.add(mouse);
        }
    }

    public void disable() {
        this.mouse.clear();
    }

    public void disable(Mouse ... mouseArray) {
        for (Mouse mouse : mouseArray) {
            this.mouse.remove(mouse);
        }
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String string) {
        this.text.setText(string);
        this.text.setColor(this.foreground);
        this.setTextSize();
    }

    public double getRotationAddition() {
        return 0.0;
    }

    public double getScaleFactor() {
        return 1.0;
    }

    public Point2D.Double getTranslation() {
        return new Point2D.Double();
    }
}

