/*
 * Decompiled with CFR 0.152.
 */
package fang2.network;

import fang2.core.Keyboard;
import fang2.core.Mouse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class GameConnections {
    private Keyboard[] keyboard;
    private Mouse[] mouse;
    private boolean isPaused = true;
    public static final int TIME_BETWEEN_UPDATES = 40;
    public static final int HEART_BEAT = 100;
    private Object[] message;
    private LinkedList<Object>[] pendingMessages;
    private LinkedList<Character>[] pendingKeystrokes;
    private Timer timer;
    private boolean hasReadClients = true;
    protected ObjectInputStream[] in;
    private ObjectOutputStream[] out;
    private boolean[] activeStreams;
    private double currentTime = -1.0;
    private int pauseCount;

    public GameConnections(String string, String string2, int n) {
        this.in = new ObjectInputStream[n];
        this.out = new ObjectOutputStream[n];
        this.keyboard = new Keyboard[n];
        this.mouse = new Mouse[n];
        this.message = new Object[n];
        this.pendingMessages = new LinkedList[n];
        this.pendingKeystrokes = new LinkedList[n];
        this.activeStreams = new boolean[n];
        for (int i = 0; i < this.keyboard.length; ++i) {
            this.keyboard[i] = new Keyboard();
            this.mouse[i] = new Mouse();
            this.message[i] = new Long(System.currentTimeMillis());
            this.activeStreams[i] = false;
            this.pendingMessages[i] = new LinkedList();
            this.pendingKeystrokes[i] = new LinkedList();
        }
    }

    public boolean isFull() {
        for (boolean bl : this.activeStreams) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    private int getPlayersLeft() {
        int n = 0;
        for (boolean bl : this.activeStreams) {
            if (bl) continue;
            ++n;
        }
        return n;
    }

    public boolean isActive() {
        if (this.currentTime < 0.0) {
            this.sendJoinedMessage(this.getPlayersLeft());
        }
        for (boolean bl : this.activeStreams) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private int getFirstInactiveStream() {
        int n;
        for (n = 0; n < this.activeStreams.length && this.activeStreams[n]; ++n) {
        }
        return n;
    }

    private void sendFirstClientMessage() throws IOException {
        for (ObjectOutputStream objectOutputStream : this.out) {
            objectOutputStream.writeObject(this.keyboard);
            objectOutputStream.writeObject(this.mouse);
            objectOutputStream.writeObject(this.message);
            objectOutputStream.flush();
            objectOutputStream.reset();
        }
    }

    private void sendJoinedMessage(int n) {
        for (int i = 0; i < this.out.length; ++i) {
            ObjectOutputStream objectOutputStream = this.out[i];
            if (!this.activeStreams[i]) continue;
            try {
                objectOutputStream.writeInt(n);
                objectOutputStream.flush();
                objectOutputStream.reset();
                continue;
            }
            catch (IOException iOException) {
                this.handleBrokenConnection(i);
            }
        }
    }

    private void handleBrokenConnection(int n) {
        if (this.isFull()) {
            for (int i = 0; i < this.out.length; ++i) {
                try {
                    this.out[i].close();
                    this.in[i].close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.activeStreams[i] = false;
                this.out[i] = null;
                this.in[i] = null;
            }
        } else if (n < this.activeStreams.length) {
            this.activeStreams[n] = false;
        }
    }

    public boolean addConnection(ObjectOutputStream objectOutputStream, ObjectInputStream objectInputStream) {
        if (this.currentTime > 0.0) {
            try {
                objectOutputStream.writeObject("Game already in play.");
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
        int n = this.getFirstInactiveStream();
        if (n == this.out.length) {
            try {
                objectOutputStream.writeObject("Game already full.");
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
        try {
            this.activeStreams[n] = true;
            this.out[n] = objectOutputStream;
            this.in[n] = objectInputStream;
            this.out[n].writeObject("Success");
            this.out[n].flush();
            this.out[n].writeInt(n);
            this.out[n].flush();
            this.sendJoinedMessage(1);
            this.sendJoinedMessage(this.getPlayersLeft());
            if (this.isFull()) {
                this.currentTime = 0.0;
                this.sendFirstClientMessage();
                this.startThreads();
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.handleBrokenConnection(n);
            return false;
        }
    }

    private void readAvailable() {
        for (int i = 0; i < this.out.length; ++i) {
            if (!this.activeStreams[i] || !this.readAvailable(i)) continue;
            this.hasReadClients = true;
        }
    }

    private void writeClient(int n) throws IOException {
        this.out[n].reset();
        this.out[n].writeDouble(this.currentTime);
        if (!this.hasReadClients) {
            this.out[n].writeBoolean(false);
        } else {
            this.out[n].writeBoolean(true);
            for (int i = 0; i < this.keyboard.length; ++i) {
                this.keyboard[i].writeExternal(this.out[n]);
                this.mouse[i].writeExternal(this.out[n]);
                if (this.message[i] == null) {
                    this.out[n].writeBoolean(false);
                    continue;
                }
                this.out[n].writeBoolean(true);
                this.out[n].writeObject(this.message[i]);
            }
            this.out[n].writeBoolean(this.isPaused);
        }
    }

    private void writeClients() {
        for (int i = 0; i < this.out.length; ++i) {
            try {
                if (!this.activeStreams[i]) continue;
                this.writeClient(i);
                continue;
            }
            catch (IOException iOException) {
                this.activeStreams[i] = false;
            }
        }
        this.hasReadClients = false;
    }

    private void flushClients() {
        for (int i = 0; i < this.out.length; ++i) {
            try {
                this.out[i].flush();
                continue;
            }
            catch (IOException iOException) {
                this.activeStreams[i] = false;
            }
        }
    }

    private void clearInputDevices() {
        for (int i = 0; i < this.keyboard.length; ++i) {
            this.mouse[i].clearClicks();
            if (this.pendingKeystrokes[i].isEmpty()) {
                this.keyboard[i].clear();
            } else {
                this.keyboard[i].setLastKey(this.pendingKeystrokes[i].removeFirst().charValue());
                this.hasReadClients = true;
            }
            if (!this.mouse[i].buttonPressed()) {
                this.mouse[i].clear();
            }
            if (this.pendingMessages[i].isEmpty()) {
                this.message[i] = null;
                continue;
            }
            this.message[i] = this.pendingMessages[i].removeFirst();
            this.hasReadClients = true;
        }
    }

    public void write() {
        this.readAvailable();
        if (this.isPaused) {
            ++this.pauseCount;
            if (this.pauseCount % 100 == 0) {
                this.pauseCount = 0;
                this.writeClients();
                this.flushClients();
            }
            return;
        }
        this.pauseCount = 0;
        this.currentTime += 0.04;
        this.writeClients();
        this.flushClients();
        this.clearInputDevices();
    }

    public boolean readAvailable(int n) {
        try {
            boolean bl = false;
            if (this.in[n].available() <= 0) {
                return bl;
            }
            while (this.in[n].available() > 0) {
                if (!this.in[n].readBoolean()) continue;
                if (this.keyboard[n].getLastKey() != '\uffff') {
                    char c = this.keyboard[n].getLastKey();
                    this.keyboard[n].setLastKey('\uffff');
                    this.keyboard[n].readExternal(this.in[n]);
                    if (this.keyboard[n].getLastKey() != '\uffff') {
                        this.pendingKeystrokes[n].addLast(Character.valueOf(this.keyboard[n].getLastKey()));
                    }
                    this.keyboard[n].setLastKey(c);
                } else {
                    this.keyboard[n].readExternal(this.in[n]);
                }
                this.mouse[n].readExternal(this.in[n]);
                if (this.in[n].readBoolean()) {
                    Object object = this.in[n].readObject();
                    if (this.message[n] != null) {
                        this.pendingMessages[n].addLast(object);
                    } else {
                        this.message[n] = object;
                    }
                }
                if (this.in[n].readBoolean()) {
                    if (this.currentTime == 0.0 && this.isPaused) {
                        this.isPaused = false;
                    }
                    if (this.currentTime > 1.0) {
                        this.isPaused = !this.isPaused;
                    }
                }
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            this.activeStreams[n] = false;
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepThreadAlive() {
        ObjectInputStream[] objectInputStreamArray = this.in;
        synchronized (this.in) {
            try {
                this.in.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public void startThreads() {
        this.currentTime = 0.0;
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        this.timer.scheduleAtFixedRate((TimerTask)new WriterThread(), 0L, 40L);
        this.keepThreadAlive();
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    class WriterThread
    extends TimerTask {
        WriterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            GameConnections.this.write();
            if (GameConnections.this.isActive()) return;
            ObjectInputStream[] objectInputStreamArray = GameConnections.this.in;
            synchronized (GameConnections.this.in) {
                GameConnections.this.in.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.cancel();
                return;
            }
        }
    }
}

