/*
 * Decompiled with CFR 0.152.
 */
package fang2.network;

import fang2.core.GameLoop;
import fang2.core.Keyboard;
import fang2.core.Mouse;
import fang2.network.Server;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;

public class Client
implements Observer {
    private long sends;
    private long sendTime = -1L;
    private long[] rtt = new long[3];
    private int id;
    public Keyboard[] keyboard;
    public Mouse[] mouse;
    public Object[] message;
    private Keyboard localKeyboard;
    private Mouse localMouse;
    private Object localMessage;
    private GameLoop frameAdvancer;
    private ObjectInputStream in;
    private ObjectOutputStream out;
    private Timer readTimer;
    private String game;
    private String session;
    private String machine;
    private int players;
    private boolean sendPause;
    private boolean isPaused = true;
    private boolean pausing = false;
    private boolean changed = true;

    public Client(String string, String string2, String string3, int n, GameLoop gameLoop) {
        this.frameAdvancer = gameLoop;
        this.machine = string;
        this.game = string2;
        this.session = string3;
        this.players = n;
        this.readTimer = new Timer(true);
        this.connectToServer();
    }

    private static void flushHttpResponse(InputStream inputStream) throws IOException {
        int n;
        int[] nArray = new int[4];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = inputStream.read();
        }
        while (nArray[0] != 10 || nArray[1] != 13 || nArray[2] != 10 || nArray[3] != 13) {
            for (n = 3; n > 0; --n) {
                nArray[n] = nArray[n - 1];
            }
            nArray[0] = inputStream.read();
        }
    }

    private static Socket getConnectedSocket(String string, int n) throws Exception {
        try {
            throw new Exception("Code not used");
        }
        catch (Exception exception) {
            Socket socket = new Socket(string, n);
            return socket;
        }
    }

    public static String[] getWaitingSessions(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            Socket socket = Client.getConnectedSocket(string, Server.PORT);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(socket.getInputStream(), 1000));
            objectOutputStream.writeObject("List Games");
            objectOutputStream.flush();
            String string3 = (String)objectInputStream.readObject();
            for (String string4 : string3.split("\n")) {
                if (string4.trim().length() <= 0) continue;
                String[] stringArray = string4.split(" ");
                String string5 = stringArray[1];
                String string6 = stringArray[3];
                if (!string5.equals(string2)) continue;
                linkedList.add(string6);
            }
            objectOutputStream.writeObject("Quit");
            objectOutputStream.flush();
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkedList.toArray(new String[0]);
    }

    public void setLocalMessage(Object object) {
        this.localMessage = object;
        this.update(null, null);
    }

    public void setGameLoop(GameLoop gameLoop) {
        this.frameAdvancer = gameLoop;
    }

    public void setLocalKeyboard(Keyboard keyboard) {
        this.localKeyboard = keyboard;
        keyboard.setCanvas(this.frameAdvancer.getCanvas());
    }

    public void setLocalMouse(Mouse mouse) {
        this.localMouse = mouse;
        mouse.setCanvas(this.frameAdvancer.getCanvas());
        mouse.addListeners();
    }

    private void tryToConnect() throws Exception {
        Socket socket = Client.getConnectedSocket(this.machine, Server.PORT);
        this.out = new ObjectOutputStream(socket.getOutputStream());
        this.in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream(), 1000));
        this.out.writeObject("Join " + this.game + " " + this.session + " " + this.players);
        this.out.flush();
        String string = (String)this.in.readObject();
        if (!string.equals("Success")) {
            this.out.close();
            this.in.close();
            this.out = null;
            this.in = null;
            return;
        }
        this.id = this.in.readInt();
        int n = this.in.readInt();
        while (n > 0) {
            n = this.in.readInt();
            if (n == 1) {
                this.frameAdvancer.setLoadMessage("Waiting for " + n + " player to join.");
                continue;
            }
            this.frameAdvancer.setLoadMessage("Waiting for " + n + " players to join.");
        }
        this.frameAdvancer.setLoadMessage("Loading Game...");
        this.keyboard = (Keyboard[])this.in.readObject();
        this.mouse = (Mouse[])this.in.readObject();
        this.message = (Object[])this.in.readObject();
        this.setMouseBoundary();
    }

    private void tryToConnect(Server server) throws Exception {
        this.out = server.getPipedOutput();
        this.in = server.getPipedInput();
        server.start();
        this.out.writeObject("Join " + this.game + " " + this.session + " " + this.players);
        this.out.flush();
        Object object = this.in.readObject();
        if (!object.equals("Success")) {
            this.out.close();
            this.in.close();
            this.out = null;
            this.in = null;
            return;
        }
        this.id = this.in.readInt();
        int n = this.in.readInt();
        while (n > 0) {
            n = this.in.readInt();
            this.frameAdvancer.setLoadMessage("Waiting for " + n + " players to join.");
        }
        this.frameAdvancer.setLoadMessage("Loading Game...");
        this.keyboard = (Keyboard[])this.in.readObject();
        this.mouse = (Mouse[])this.in.readObject();
        this.message = (Object[])this.in.readObject();
        this.setMouseBoundary();
    }

    private void setMouseBoundary() {
        for (Mouse mouse : this.mouse) {
            mouse.setCanvas(this.frameAdvancer.getCanvas());
        }
    }

    public boolean isConnected() {
        return this.out != null;
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "localhost";
        }
    }

    private void connectToServer() {
        block6: {
            try {
                if (this.players == 1) {
                    Server server = new Server(this.readTimer);
                    this.tryToConnect(server);
                    break block6;
                }
                if (this.machine.equals("localhost") || this.machine.equals(Client.getHostname())) {
                    try {
                        new Server(false, this.readTimer).start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.tryToConnect();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private TimerTask getWriteTask() {
        return new TimerTask(){

            public void run() {
                try {
                    if (Client.this.isPaused && !Client.this.sendPause) {
                        return;
                    }
                    Client.this.out.writeBoolean(Client.this.changed);
                    if (!Client.this.changed) {
                        return;
                    }
                    Client.this.changed = false;
                    Client.this.localKeyboard.writeExternal(Client.this.out);
                    Client.this.localMouse.writeExternal(Client.this.out);
                    Client.this.localKeyboard.clear();
                    Client.this.localMouse.clearClicks();
                    if (!Client.this.localMouse.buttonPressed()) {
                        Client.this.localMouse.clear();
                    }
                    if (Client.this.localMessage == null) {
                        Client.this.out.writeBoolean(false);
                    } else {
                        Client.this.out.writeBoolean(true);
                        Client.this.out.writeObject(Client.this.localMessage);
                        Client.this.localMessage = null;
                    }
                    Client.this.out.writeBoolean(Client.this.sendPause);
                    Client.this.sendPause = false;
                    Client.this.out.flush();
                    Client.this.out.reset();
                    Client.this.sendTime = System.currentTimeMillis();
                    Client.this.sends++;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    private void write() throws IOException {
        try {
            if (this.readTimer != null) {
                this.readTimer.schedule(this.getWriteTask(), 0L);
            }
        }
        catch (Exception exception) {
            this.readTimer = null;
        }
    }

    public void clearInput() {
        this.localKeyboard.clear();
        this.localMouse.clearClicks();
        for (int i = 0; i < this.keyboard.length; ++i) {
            this.keyboard[i].clear();
            this.mouse[i].clearClicks();
            this.message[i] = null;
        }
    }

    public void pauseToggle() {
        if (this.pausing) {
            return;
        }
        this.sendPause = true;
        this.update(null, null);
        this.pausing = true;
    }

    private boolean read() throws IOException, ClassNotFoundException {
        if (this.in.available() <= 0) {
            return false;
        }
        double d = this.in.readDouble();
        if (this.in.readBoolean()) {
            int n;
            for (n = 0; n < this.keyboard.length; ++n) {
                this.keyboard[n].clear();
                this.mouse[n].clearClicks();
                this.keyboard[n].readExternal(this.in);
                this.mouse[n].readExternal(this.in);
                this.message[n] = this.in.readBoolean() ? this.in.readObject() : null;
            }
            n = this.isPaused ? 1 : 0;
            this.isPaused = this.in.readBoolean();
            if (this.isPaused != n) {
                this.pausing = false;
                this.frameAdvancer.serverSaysPauseToggle();
            }
        }
        this.update(null, null);
        this.frameAdvancer.updateModel(d);
        if (this.sendTime > 0L) {
            long l = System.currentTimeMillis();
            this.rtt[0] = Math.min(this.rtt[0], l - this.sendTime);
            this.rtt[1] = this.rtt[1] + (l - this.sendTime);
            this.rtt[2] = Math.max(this.rtt[2], l - this.sendTime);
            this.sendTime = -1L;
        }
        return true;
    }

    public void connect() {
        this.localKeyboard.setObserver(this);
        this.localMouse.setObserver(this);
        final ReaderThread readerThread = new ReaderThread();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                readerThread.actionPerformed(null);
            }
        };
        this.readTimer.scheduleAtFixedRate(timerTask, 0L, 4L);
    }

    public void disconnect() {
        this.isPaused = true;
        this.readTimer.cancel();
        try {
            this.in.close();
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public int getID() {
        return this.id;
    }

    public void update(Observable observable, Object object) {
        try {
            if (this.pausing || this.isPaused) {
                this.localKeyboard.clear();
                this.localMouse.clearClicks();
            }
            this.changed = true;
            this.write();
        }
        catch (IOException iOException) {
            this.disconnect();
            iOException.printStackTrace();
        }
    }

    class ReaderThread
    implements ActionListener {
        private Runnable inEventThread = new Runnable(){

            public void run() {
                Client.this.frameAdvancer.refreshScreen();
            }
        };

        ReaderThread() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (!Client.this.read()) {
                    return;
                }
                while (Client.this.read()) {
                }
                EventQueue.invokeAndWait(this.inEventThread);
            }
            catch (Exception exception) {
                Client.this.disconnect();
                exception.printStackTrace();
            }
        }
    }
}

