/*
 * Decompiled with CFR 0.152.
 */
package fang2.media;

public abstract class SequentialSound {
    double pan = 0.5;
    double volume = 1.0;
    boolean muted;
    boolean paused;

    public abstract double getClipPosition();

    public abstract void setClipPosition(double var1);

    public abstract double getClipLength();

    public abstract void play();

    public abstract void pause();

    public abstract void mute();

    public abstract void turnSoundOn();

    public abstract void setLooping(boolean var1);

    public abstract void setLooping(int var1);

    public abstract int getLoopsLeft();

    public abstract boolean isLoaded();

    public abstract boolean isMuted();

    public abstract boolean isPaused();

    public abstract SequentialSound getDuplicate();

    public boolean isFinishedPlaying() {
        return !this.isLooping() && this.getClipPosition() + 0.01 >= this.getClipLength();
    }

    public void setVolume(double d) {
        this.volume = d;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setPan(double d) {
        this.pan = Math.max(0.0, Math.min(1.0, d));
    }

    public double getPan() {
        return this.pan;
    }

    public void start() {
        this.setClipPosition(0.0);
        this.play();
    }

    public void stop() {
        this.setClipPosition(this.getClipLength());
    }

    public void play(double d) {
        this.setPan(d);
        this.play();
    }

    public void loop() {
        this.setLooping(true);
        this.play();
    }

    public void resume() {
        this.play();
    }

    public boolean isLooping() {
        return this.getLoopsLeft() > 0;
    }

    public boolean isPlaying() {
        return !this.isFinishedPlaying() && this.getClipPosition() > 0.0;
    }
}

