/*
 * Decompiled with CFR 0.152.
 */
package fang2.media;

import fang2.media.RawMediaCache;
import fang2.media.SequentialSound;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class SampledSound
extends SequentialSound
implements RawMediaCache.MediaLoadListener {
    private static final int BUFFER_SIZE = 44100;
    private static final int TIME_INTERVAL = 100;
    private static boolean masterMuted;
    private static boolean masterPlaying;
    private static HashSet<SampledSound> activePlayable;
    private static Streamer streamer;
    private double clipLength;
    private boolean muted;
    private boolean playing = false;
    private boolean finishedPlaying = false;
    private boolean loaded = false;
    private long timeMissed = 0L;
    private int loopsLeft;
    private final byte[] byteBuffer;
    private SourceDataLine dataLine;
    private PushbackInputStream inputStream;
    private InputStream compressedIn;
    private final URL soundFile;
    private float gain = 0.0f;
    private static Class<?> MPEG_AUDIO_FILE_READER;
    private static Constructor<?> DECODED_MPEG_AUDIO_INPUT_STREAM;
    private static Class<?> OGG_AUDIO_FILE_READER;
    private static Constructor<?> DECODED_OGG_AUDIO_INPUT_STREAM;

    public SampledSound(URL uRL) {
        if (streamer == null) {
            streamer = new Streamer();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Timer timer = new Timer();
                    timer.scheduleAtFixedRate((TimerTask)streamer, 0L, 100L);
                }
            });
        }
        this.soundFile = uRL;
        this.byteBuffer = new byte[44100];
        this.loaded = RawMediaCache.isFullyLoaded(uRL);
        if (!this.loaded) {
            RawMediaCache.load(uRL, this);
        } else {
            this.prepareToPlay();
        }
        this.muted = false;
        this.loopsLeft = 0;
    }

    private void prepareToPlay() {
        this.resetStream();
        this.loaded = true;
        this.setPan();
        this.setVolume();
        this.dataLine.start();
        long l = this.getNumberOfBytesNeeded(this.timeMissed);
        try {
            if (l > 0L) {
                this.skip(l);
                this.timeMissed = 0L;
                this.update(200L);
                this.play();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int skip(long l) throws IOException {
        long l2 = this.inputStream.skip(l);
        return (int)l2;
    }

    private int readThenWrite(int n) throws IOException {
        int n2 = Math.min(n, this.byteBuffer.length);
        int n3 = this.inputStream.read(this.byteBuffer, 0, n2);
        int n4 = n3 % this.dataLine.getFormat().getFrameSize();
        if (n4 > 0) {
            this.inputStream.unread(this.byteBuffer, n3 - n4, n4);
        }
        if (n3 >= 0) {
            n3 -= n4;
        }
        if (n3 > 0 && !this.muted) {
            this.dataLine.write(this.byteBuffer, 0, n3);
        }
        return n3;
    }

    public double getClipPosition() {
        return this.dataLine.getMicrosecondPosition() / 1000L;
    }

    private long getNumberOfBytesNeeded(long l) {
        AudioFormat audioFormat = this.dataLine.getFormat();
        int n = (int)Math.ceil((double)l / 1000.0 * (double)audioFormat.getFrameRate());
        return n * audioFormat.getFrameSize();
    }

    private synchronized void update(long l) {
        if (!this.playing) {
            return;
        }
        try {
            long l2;
            if (!this.loaded) {
                this.timeMissed += l;
                l2 = 0L;
            } else {
                l2 = this.getNumberOfBytesNeeded(l);
                if (l2 > 44100L) {
                    long l3 = l2 - 44100L;
                    this.skip(l3);
                    l2 = 44100L;
                }
            }
            while (l2 > 0L) {
                int n = this.readThenWrite((int)l2);
                if (n < 0) {
                    if (this.loopsLeft > 0) {
                        --this.loopsLeft;
                        this.resetStream();
                        n = this.readThenWrite((int)l2);
                        if (n < 0) {
                            this.playing = false;
                            this.finishedPlaying = true;
                            this.resetStream();
                            continue;
                        }
                        l2 -= (long)n;
                        continue;
                    }
                    this.playing = false;
                    this.finishedPlaying = true;
                    this.resetStream();
                    l2 = 0L;
                    continue;
                }
                l2 -= (long)n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private Mixer.Info getPanMixer() {
        Mixer.Info[] infoArray;
        Mixer.Info info = null;
        for (Mixer.Info info2 : infoArray = AudioSystem.getMixerInfo()) {
            if (!"Java Sound Audio Engine".equals(info2.getName())) continue;
            info = info2;
        }
        if (info == null) {
            info = AudioSystem.getMixer(null).getMixerInfo();
        }
        return info;
    }

    private void resetStream() {
        AudioFormat audioFormat = null;
        if (this.compressedIn == null) {
            this.compressedIn = RawMediaCache.getCachedStream(this.soundFile);
        } else {
            try {
                this.compressedIn.reset();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        AudioInputStream audioInputStream = null;
        try {
            Object object;
            boolean bl = this.soundFile.toString().toLowerCase().endsWith("mp3");
            boolean bl2 = this.soundFile.toString().toLowerCase().endsWith("ogg");
            if (bl || bl2) {
                object = null;
                try {
                    if (bl) {
                        object = (AudioFileReader)MPEG_AUDIO_FILE_READER.newInstance();
                    } else if (bl2) {
                        object = (AudioFileReader)OGG_AUDIO_FILE_READER.newInstance();
                    }
                }
                catch (Exception exception) {
                    System.err.println("JavaZoom needed for this sound");
                    return;
                }
                audioInputStream = ((AudioFileReader)object).getAudioInputStream(this.compressedIn);
                audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false);
                try {
                    Object[] objectArray = new Object[]{audioFormat, audioInputStream};
                    InputStream inputStream = null;
                    if (bl) {
                        inputStream = (InputStream)DECODED_MPEG_AUDIO_INPUT_STREAM.newInstance(objectArray);
                    } else if (bl2) {
                        inputStream = (InputStream)DECODED_OGG_AUDIO_INPUT_STREAM.newInstance(objectArray);
                    }
                    this.inputStream = new PushbackInputStream(inputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("JavaZoom needed for this sound");
                }
            } else if (this.soundFile.toString().toLowerCase().endsWith("wav")) {
                object = AudioSystem.getAudioInputStream(this.compressedIn);
                this.inputStream = new PushbackInputStream((InputStream)object);
                audioFormat = ((AudioInputStream)object).getFormat();
            } else {
                System.err.println("Unsupported sound format: " + this.soundFile.toString());
                return;
            }
            if (this.dataLine == null) {
                object = this.getPanMixer();
                this.dataLine = AudioSystem.getSourceDataLine(audioFormat, (Mixer.Info)object);
                this.dataLine.open(audioFormat, 176400);
            }
            if (audioInputStream != null) {
                this.clipLength = (double)audioInputStream.getFrameLength() / (double)audioInputStream.getFormat().getFrameRate();
            }
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            unsupportedAudioFileException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
    }

    public void start() {
        this.playing = true;
        activePlayable.add(this);
        if (this.loaded) {
            this.dataLine.start();
        }
    }

    public void setPan(double d) {
        super.setPan(d);
        this.setPan();
    }

    private void setPan() {
        float f = 2.0f * (float)this.pan - 1.0f;
        try {
            if (this.dataLine != null) {
                Control control = this.dataLine.getControl(FloatControl.Type.PAN);
                ((FloatControl)control).setValue(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVolume(double d) {
        super.setVolume(d);
        this.gain = (float)Math.log10(d) * 20.0f;
        this.setVolume();
    }

    private void setVolume() {
        try {
            if (this.dataLine != null) {
                Control control = this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                ((FloatControl)control).setValue(this.gain);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void play() {
        this.start();
    }

    public void play(double d) {
        this.setPan(d);
        this.start();
    }

    public void stop() {
        this.playing = false;
        this.dataLine.stop();
        activePlayable.remove(this);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isFinishedPlaying() {
        return this.finishedPlaying;
    }

    public void mute() {
        this.muted = true;
    }

    public void turnSoundOn() {
        this.muted = false;
    }

    public void setLooping(boolean bl) {
        this.loopsLeft = bl ? Integer.MAX_VALUE : 0;
    }

    public void setLooping(int n) {
        this.loopsLeft = n - 1;
    }

    public boolean isLooping() {
        return this.loopsLeft > 0;
    }

    public URL getSoundURL() {
        return this.soundFile;
    }

    public void loop() {
        this.setLooping(true);
        this.start();
    }

    public void stopLooping() {
        this.setLooping(false);
    }

    public static void main(String[] stringArray) throws InterruptedException, MalformedURLException, Exception {
        URL uRL = SampledSound.class.getResource("VideoGameTrack.mp3");
        for (int i = 0; i < 1; ++i) {
            SampledSound sampledSound = new SampledSound(uRL);
            sampledSound.play(1.0);
            sampledSound.turnSoundOn();
        }
    }

    public double getClipLength() {
        return this.clipLength;
    }

    public SequentialSound getDuplicate() {
        SampledSound sampledSound = new SampledSound(this.soundFile);
        sampledSound.setVolume(this.getVolume());
        sampledSound.setPan(this.getPan());
        sampledSound.paused = this.paused;
        sampledSound.muted = this.muted;
        sampledSound.loopsLeft = this.loopsLeft;
        return sampledSound;
    }

    public int getLoopsLeft() {
        return this.loopsLeft;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isMuted() {
        return this.muted || masterMuted;
    }

    public boolean isPaused() {
        return !this.playing && !this.finishedPlaying || !masterPlaying;
    }

    public void pause() {
        this.playing = false;
    }

    public void resume() {
        this.playing = true;
    }

    public void setClipPosition(double d) {
        if (d == 0.0) {
            this.resetStream();
        }
    }

    public void mediaFullyLoaded() {
        this.prepareToPlay();
    }

    static {
        Class[] classArray;
        Class<?> clazz;
        activePlayable = new HashSet();
        try {
            MPEG_AUDIO_FILE_READER = Class.forName("javazoom.spi.mpeg.sampled.file.MpegAudioFileReader");
            clazz = Class.forName("javazoom.spi.mpeg.sampled.convert.DecodedMpegAudioInputStream");
            classArray = new Class[]{AudioFormat.class, AudioInputStream.class};
            DECODED_MPEG_AUDIO_INPUT_STREAM = clazz.getDeclaredConstructor(classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            OGG_AUDIO_FILE_READER = Class.forName("javazoom.spi.vorbis.sampled.file.VorbisAudioFileReader");
            clazz = Class.forName("javazoom.spi.vorbis.sampled.convert.DecodedVorbisAudioInputStream");
            classArray = new Class[]{AudioFormat.class, AudioInputStream.class};
            DECODED_OGG_AUDIO_INPUT_STREAM = clazz.getDeclaredConstructor(classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class Streamer
    extends TimerTask {
        long last = System.currentTimeMillis();

        Streamer() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            long l2 = l - this.last;
            this.last = l;
            for (SampledSound sampledSound : activePlayable.toArray(new SampledSound[0])) {
                sampledSound.update(l2);
            }
        }
    }
}

