/*
 * Decompiled with CFR 0.152.
 */
package fang2.media;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class RawMediaCache
extends Thread {
    private static final ThreadLocal<RawMediaCache> RAW = new ThreadLocal<RawMediaCache>(){

        @Override
        protected synchronized RawMediaCache initialValue() {
            return SINGLETON;
        }
    };
    private static final RawMediaCache SINGLETON = new RawMediaCache();
    private static final int BUFFER_SIZE = 8096;
    private LinkedHashMap<URL, byte[]> cache = new LinkedHashMap();
    private LinkedList<URL> queue = new LinkedList();
    private HashMap<URL, LinkedList<MediaLoadListener>> listeners = new HashMap();
    private byte[] byteBuffer = new byte[8096];
    private int megabyteLimit = 4;
    private long bytesStored = 0L;

    private RawMediaCache() {
        this.start();
    }

    public static int getQueueLength() {
        return RawMediaCache.RAW.get().queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(URL uRL) {
        LinkedList<URL> linkedList = RawMediaCache.RAW.get().queue;
        synchronized (linkedList) {
            if (!RawMediaCache.RAW.get().queue.contains(uRL)) {
                RawMediaCache.RAW.get().queue.add(uRL);
            }
            RawMediaCache.RAW.get().queue.notify();
        }
    }

    public static byte[] loadAndWait(URL uRL) {
        return RawMediaCache.loadData(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(URL uRL, MediaLoadListener mediaLoadListener) {
        LinkedList<URL> linkedList = RawMediaCache.RAW.get().queue;
        synchronized (linkedList) {
            if (!RawMediaCache.RAW.get().queue.contains(uRL)) {
                RawMediaCache.RAW.get().queue.add(uRL);
                RawMediaCache.RAW.get().queue.notify();
            }
            if (mediaLoadListener != null) {
                if (!RawMediaCache.RAW.get().listeners.containsKey(uRL)) {
                    RawMediaCache.RAW.get().listeners.put(uRL, new LinkedList());
                }
                RawMediaCache.RAW.get().listeners.get(uRL).add(mediaLoadListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCurrentlyLoading(URL uRL) {
        boolean bl = false;
        LinkedList<URL> linkedList = RawMediaCache.RAW.get().queue;
        synchronized (linkedList) {
            bl = RawMediaCache.RAW.get().queue.contains(uRL);
        }
        return bl;
    }

    public static boolean isFullyLoaded(URL uRL) {
        return RawMediaCache.RAW.get().cache.containsKey(uRL) && RawMediaCache.RAW.get().cache.get(uRL) != null;
    }

    public static boolean hasLoadError(URL uRL) {
        return RawMediaCache.RAW.get().cache.containsKey(uRL) && RawMediaCache.RAW.get().cache.get(uRL) == null;
    }

    public static InputStream getCachedStream(URL uRL) {
        ByteArrayInputStream byteArrayInputStream = null;
        byte[] byArray = !RawMediaCache.isFullyLoaded(uRL) ? RawMediaCache.loadAndWait(uRL) : RawMediaCache.RAW.get().cache.get(uRL);
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        RawMediaCache.RAW.get().cache.remove(uRL);
        RawMediaCache.RAW.get().cache.put(uRL, byArray);
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadData(URL uRL) {
        LinkedHashMap<URL, byte[]> linkedHashMap = RawMediaCache.RAW.get().cache;
        synchronized (linkedHashMap) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream inputStream = uRL.openStream();
                int n = inputStream.read(RawMediaCache.RAW.get().byteBuffer);
                while (n >= 0) {
                    byteArrayOutputStream.write(RawMediaCache.RAW.get().byteBuffer, 0, n);
                    n = inputStream.read(RawMediaCache.RAW.get().byteBuffer);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length <= RawMediaCache.RAW.get().megabyteLimit << 20) {
                    RawMediaCache.RAW.get().cache.put(uRL, byArray);
                } else {
                    double d = (double)byArray.length / 1048576.0;
                    d = (double)Math.round(d * 100.0) / 100.0;
                    System.err.println("Too big: " + uRL + "\n" + "Size of URL is " + d + " MB." + "\n" + "Size of cache is " + RawMediaCache.RAW.get().megabyteLimit + " MB.");
                }
                RawMediaCache.RAW.get().bytesStored += (long)byArray.length;
                RawMediaCache.maintainCacheLimit();
                return byArray;
            }
            catch (IOException iOException) {
                RawMediaCache.RAW.get().cache.put(uRL, null);
                iOException.printStackTrace();
                return null;
            }
        }
    }

    private static void maintainCacheLimit() {
        if (RawMediaCache.RAW.get().bytesStored > (long)(RawMediaCache.RAW.get().megabyteLimit << 20)) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (URL uRL : RawMediaCache.RAW.get().cache.keySet()) {
                arrayList.add(uRL);
                RawMediaCache.RAW.get().bytesStored -= (long)RawMediaCache.RAW.get().cache.get(uRL).length;
                if (RawMediaCache.RAW.get().bytesStored >= (long)(RawMediaCache.RAW.get().megabyteLimit << 20)) continue;
                break;
            }
            for (URL uRL : arrayList) {
                RawMediaCache.RAW.get().cache.remove(uRL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = null;
        block8: while (true) {
            var2_2 = this.queue;
            synchronized (var2_2) {
                while (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException var3_4) {
                        var3_4.printStackTrace();
                    }
                }
                var1_1 = this.queue.getFirst();
            }
            RawMediaCache.loadData(var1_1);
            var2_2 = this.queue;
            synchronized (var2_2) {
                this.queue.removeFirst();
            }
            if (!this.listeners.containsKey(var1_1)) continue;
            var2_2 = this.listeners.get(var1_1).iterator();
            while (true) {
                if (var2_2.hasNext()) ** break;
                continue block8;
                var3_3 = (MediaLoadListener)var2_2.next();
                var3_3.mediaFullyLoaded();
            }
            break;
        }
    }

    public static void main(String[] stringArray) {
    }

    public static interface MediaLoadListener {
        public void mediaFullyLoaded();
    }
}

