/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.attributes.Location2D;
import fang2.attributes.Vector2D;
import fang2.core.Sprite;
import fang2.core.Transformer;

public class TransformerAdapter
implements Transformer {
    private Location2D deltaLocation;
    private double deltaRotationRadians;
    private final double deltaScale;

    public TransformerAdapter() {
        this(new Location2D(), 0.0, 1.0);
    }

    public TransformerAdapter(Location2D location2D, double d, double d2) {
        this.deltaLocation = location2D;
        this.deltaRotationRadians = d;
        this.deltaScale = d2;
    }

    public void advance(double d) {
    }

    public Location2D getLocation() {
        return this.deltaLocation;
    }

    public double getRotation() {
        return this.deltaRotationRadians;
    }

    public final double getRotationDegrees() {
        return Math.toDegrees(this.getRotation());
    }

    public final double getRotationRadians() {
        return this.getRotation();
    }

    public final double getRotationRevolutions() {
        return this.getRotation() / (Math.PI * 2);
    }

    public double getScale() {
        return this.deltaScale;
    }

    public void nonMaskableAdvance(double d) {
    }

    public void setLocation(Location2D location2D) {
        this.deltaLocation = location2D;
    }

    public void setLocation(Vector2D vector2D) {
        this.deltaLocation = new Location2D(vector2D);
    }

    public void setRotation(double d) {
        this.deltaRotationRadians = d;
    }

    public final void setRotationDegrees(double d) {
        this.setRotation(Math.toRadians(d));
    }

    public final void setRotationRadians(double d) {
        this.setRotation(d);
    }

    public final void setRotationRevolutions(double d) {
        this.setRotation(d * Math.PI * 2.0);
    }

    public void updateSprite(Sprite sprite) {
        sprite.translate(this.deltaLocation);
        sprite.rotate(this.deltaRotationRadians);
        sprite.scale(this.deltaScale);
    }
}

