/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.core.GameLoop;
import fang2.media.MidiSound;
import fang2.media.RawMediaCache;
import fang2.media.SampledSound;
import fang2.media.SequentialSound;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;

public class Sound
extends SequentialSound {
    private static ArrayList<WeakReference<Sound>> allSounds = new ArrayList();
    private static boolean muted = true;
    private static boolean paused = true;
    private ArrayList<SequentialSound> clips;
    private URL soundFile;

    public Sound(URL uRL) {
        this.initialize(uRL);
    }

    public Sound(String string) {
        this.initialize(GameLoop.getGameResource(string));
    }

    private void initialize(URL uRL) {
        allSounds.add(new WeakReference<Sound>(this));
        this.soundFile = uRL;
        this.clips = new ArrayList();
        String string = uRL.toString().toLowerCase();
        if (string.endsWith("mp3") || string.endsWith(".wav") || string.endsWith(".ogg")) {
            this.clips.add(new SampledSound(uRL));
        } else if (string.endsWith(".mid") || string.endsWith("midi")) {
            this.clips.add(new MidiSound(uRL));
        } else {
            System.err.println("Unsupported sound format:" + string);
        }
        this.mute();
        this.pause();
    }

    public double getClipLength() {
        return this.clips.get(0).getClipLength();
    }

    public double getClipPosition() {
        double d = 0.0;
        for (SequentialSound sequentialSound : this.clips) {
            if (!sequentialSound.isPlaying()) continue;
            d = sequentialSound.getClipPosition();
            break;
        }
        return d;
    }

    public SequentialSound getDuplicate() {
        return new Sound(this.soundFile);
    }

    public int getLoopsLeft() {
        return this.clips.get(0).getLoopsLeft();
    }

    public double getPan() {
        return this.clips.get(0).getPan();
    }

    public double getVolume() {
        return this.clips.get(0).getVolume();
    }

    public boolean isFinishedPlaying() {
        boolean bl = true;
        for (SequentialSound sequentialSound : this.clips) {
            bl = bl && sequentialSound.isFinishedPlaying();
        }
        return bl;
    }

    public boolean isLoaded() {
        return this.clips.get(0).isLoaded();
    }

    public boolean isLooping() {
        return this.clips.get(0).isLooping();
    }

    public boolean isMuted() {
        return this.clips.get(0).isMuted();
    }

    public boolean isPaused() {
        return this.clips.get(0).isPaused();
    }

    public boolean isPlaying() {
        boolean bl = false;
        for (SequentialSound sequentialSound : this.clips) {
            bl = bl || sequentialSound.isPlaying();
        }
        return bl;
    }

    public void loop() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.loop();
        }
    }

    public static void muteAll() {
        muted = true;
        ArrayList<WeakReference<Sound>> arrayList = new ArrayList<WeakReference<Sound>>();
        for (WeakReference<Sound> weakReference : allSounds) {
            Sound sound = (Sound)weakReference.get();
            if (sound == null) {
                arrayList.add(weakReference);
                continue;
            }
            sound.mute();
        }
        allSounds.removeAll(arrayList);
    }

    public static void turnAllSoundOn() {
        muted = false;
        ArrayList<WeakReference<Sound>> arrayList = new ArrayList<WeakReference<Sound>>();
        for (WeakReference<Sound> weakReference : allSounds) {
            Sound sound = (Sound)weakReference.get();
            if (sound == null) {
                arrayList.add(weakReference);
                continue;
            }
            sound.turnSoundOn();
        }
        allSounds.removeAll(arrayList);
    }

    public static void pauseAll() {
        paused = true;
        ArrayList<WeakReference<Sound>> arrayList = new ArrayList<WeakReference<Sound>>();
        for (WeakReference<Sound> weakReference : allSounds) {
            Sound sound = (Sound)weakReference.get();
            if (sound == null) {
                arrayList.add(weakReference);
                continue;
            }
            sound.pause();
        }
        allSounds.removeAll(arrayList);
    }

    public static void resumeAll() {
        paused = false;
        ArrayList<WeakReference<Sound>> arrayList = new ArrayList<WeakReference<Sound>>();
        for (WeakReference<Sound> weakReference : allSounds) {
            Sound sound = (Sound)weakReference.get();
            if (sound == null) {
                arrayList.add(weakReference);
                continue;
            }
            sound.resume();
        }
        allSounds.removeAll(arrayList);
    }

    public void mute() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.mute();
        }
    }

    public void pause() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.pause();
        }
    }

    private SequentialSound getNextAvailable() {
        SequentialSound sequentialSound = null;
        for (SequentialSound sequentialSound2 : this.clips) {
            if (!sequentialSound2.isLoaded() || !sequentialSound2.isFinishedPlaying()) continue;
            sequentialSound = sequentialSound2;
            break;
        }
        if (sequentialSound == null) {
            sequentialSound = this.clips.get(0).getDuplicate();
            this.clips.add(sequentialSound);
        }
        return sequentialSound;
    }

    public void play() {
        SequentialSound sequentialSound = this.getNextAvailable();
        sequentialSound.play();
        if (muted) {
            sequentialSound.mute();
        }
        if (paused) {
            sequentialSound.pause();
        }
    }

    public void play(double d) {
        SequentialSound sequentialSound = this.getNextAvailable();
        sequentialSound.play(d);
    }

    public void resume() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.resume();
        }
    }

    public void setLooping(boolean bl) {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.setLooping(bl);
        }
    }

    public void setLooping(int n) {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.setLooping(n);
        }
    }

    public void setPan(double d) {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.setPan(d);
        }
    }

    public void setVolume(double d) {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.setVolume(d);
        }
    }

    public void start() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.start();
        }
    }

    public void stop() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.stop();
        }
    }

    public void turnSoundOn() {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.turnSoundOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws InterruptedException {
        URL uRL = SampledSound.class.getResource("VideoGameTrack.mp3");
        RawMediaCache.loadAndWait(uRL);
        uRL = SampledSound.class.getResource("DingLower.wav");
        Sound sound = new Sound(uRL);
        sound.setVolume(0.2);
        sound.setPan(1.0);
        Sound sound2 = new Sound(uRL);
        sound2.setVolume(0.2);
        sound2.setPan(0.0);
        URL uRL2 = uRL;
        synchronized (uRL2) {
            uRL.wait(1000L);
        }
        sound2.play();
    }

    public void setClipPosition(double d) {
        for (SequentialSound sequentialSound : this.clips) {
            sequentialSound.setClipPosition(d);
        }
    }
}

