/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.attributes.Location2D;
import fang2.core.AnimationCanvas;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Observer;

public class Mouse
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Location2D mousePosition;
    private Location2D lastMousePosition;
    private transient AnimationCanvas canvas;
    private Location2D mouseClick;
    private Location2D leftClick;
    private Location2D middleClick;
    private Location2D rightClick;
    private boolean mouseDown = false;
    private transient boolean leftDown = false;
    private transient boolean middleDown = false;
    private transient boolean rightDown = false;
    private Observer observer;
    protected Listener listener = new Listener();

    public Mouse() {
        this.lastMousePosition = new Location2D();
    }

    public String toString() {
        return "Mouse at " + this.mousePosition;
    }

    public void setCanvas(AnimationCanvas animationCanvas) {
        this.canvas = animationCanvas;
    }

    public void addListeners() {
        this.canvas.addMouseListener(this.listener);
        this.canvas.addMouseMotionListener(this.listener);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.mouseDown);
        this.writePoint(objectOutput, this.mousePosition);
        this.writePoint(objectOutput, this.mouseClick);
        this.writePoint(objectOutput, this.leftClick);
        this.writePoint(objectOutput, this.middleClick);
        this.writePoint(objectOutput, this.rightClick);
    }

    private void writePoint(ObjectOutput objectOutput, Location2D location2D) throws IOException {
        if (location2D == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeDouble(location2D.getX());
            objectOutput.writeDouble(location2D.getY());
        }
    }

    private Location2D readPoint(ObjectInput objectInput, Location2D location2D) throws IOException {
        if (objectInput.readBoolean()) {
            if (location2D != null) {
                location2D.setLocation(objectInput.readDouble(), objectInput.readDouble());
            } else {
                location2D = new Location2D(objectInput.readDouble(), objectInput.readDouble());
            }
        }
        return location2D;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        boolean bl = this.mouseDown;
        this.mouseDown = objectInput.readBoolean();
        this.mousePosition = this.readPoint(objectInput, this.mousePosition);
        if (this.mousePosition != null) {
            this.lastMousePosition.setLocation(this.mousePosition.getX(), this.mousePosition.getY());
        }
        this.mouseClick = this.readPoint(objectInput, this.mouseClick);
        this.leftClick = this.readPoint(objectInput, this.leftClick);
        this.middleClick = this.readPoint(objectInput, this.middleClick);
        this.rightClick = this.readPoint(objectInput, this.rightClick);
        if (!bl && this.mouseDown) {
            if (this.leftClick != null) {
                this.leftDown = true;
            }
            if (this.middleClick != null) {
                this.middleDown = true;
            }
            if (this.rightClick != null) {
                this.rightDown = true;
            }
        } else if (bl && !this.mouseDown) {
            this.leftDown = false;
            this.middleDown = false;
            this.rightDown = false;
        }
    }

    public void clear() {
        this.mousePosition = null;
        this.mouseDown = false;
        this.leftDown = false;
        this.middleDown = false;
        this.rightDown = false;
        this.clearClicks();
    }

    public void clearClicks() {
        this.mouseClick = null;
        this.leftClick = null;
        this.rightClick = null;
        this.middleClick = null;
        this.leftDown = false;
        this.middleDown = false;
        this.rightDown = false;
    }

    public Location2D getLocation() {
        return new Location2D(this.lastMousePosition);
    }

    public Location2D getClickLocation() {
        if (this.mouseClick == null) {
            return null;
        }
        return new Location2D(this.mouseClick);
    }

    public Location2D getLeftClickLocation() {
        if (this.leftClick == null) {
            return null;
        }
        return new Location2D(this.leftClick);
    }

    public Location2D getMiddleClickLocation() {
        if (this.middleClick == null) {
            return null;
        }
        return new Location2D(this.middleClick);
    }

    public Location2D getRightClickLocation() {
        if (this.rightClick == null) {
            return null;
        }
        return new Location2D(this.rightClick);
    }

    public boolean buttonPressed() {
        return this.mouseDown;
    }

    public boolean leftPressed() {
        return this.leftDown;
    }

    public boolean middlePressed() {
        return this.middleDown;
    }

    public boolean rightPressed() {
        return this.rightDown;
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    public void notifyObserver() {
        if (this.observer != null) {
            this.observer.update(null, null);
        }
    }

    private Location2D getPoint2D(Point point) {
        if (this.canvas == null) {
            return new Location2D();
        }
        double d = Math.min(this.canvas.getWidth(), this.canvas.getHeight());
        Location2D location2D = new Location2D((double)point.x / d, (double)point.y / d);
        if (this.canvas.getAspect() > 1.0) {
            location2D.setLocation(Math.min(this.canvas.getAspect(), location2D.getX()), Math.min(1.0, location2D.getY()));
        } else {
            location2D.setLocation(Math.min(1.0, location2D.getX()), Math.min(1.0 / this.canvas.getAspect(), location2D.getY()));
        }
        location2D.setLocation(Math.max(0.0, location2D.getX()), Math.max(0.0, location2D.getY()));
        return location2D;
    }

    protected class Listener
    implements MouseListener,
    MouseMotionListener {
        protected Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Location2D location2D = Mouse.this.getPoint2D(mouseEvent.getPoint());
            if (!location2D.equals(Mouse.this.mousePosition)) {
                Mouse.this.mousePosition = location2D;
                Mouse.this.notifyObserver();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Location2D location2D = Mouse.this.getPoint2D(mouseEvent.getPoint());
            if (!location2D.equals(Mouse.this.mousePosition)) {
                Mouse.this.mousePosition = location2D;
                Mouse.this.notifyObserver();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Mouse.this.mouseDown = true;
            Mouse.this.mouseClick = Mouse.this.getPoint2D(mouseEvent.getPoint());
            if (mouseEvent.getButton() == 1) {
                Mouse.this.leftClick = Mouse.this.mouseClick;
            } else if (mouseEvent.getButton() == 2) {
                Mouse.this.middleClick = Mouse.this.mouseClick;
            } else if (mouseEvent.getButton() == 3) {
                Mouse.this.rightClick = Mouse.this.mouseClick;
            }
            Mouse.this.notifyObserver();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Mouse.this.mouseDown = false;
            Mouse.this.notifyObserver();
        }
    }
}

