/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.core.FrameAdvancer;
import fang2.core.GameLevel;
import fang2.core.Keyboard;
import fang2.core.Mouse;
import fang2.core.Player;
import fang2.media.RawMediaCache;
import fang2.network.Client;
import fang2.sprites.ImageSprite;
import fang2.util.InitializeApplication;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class GameLoop
extends FrameAdvancer {
    public static final long SEED = 1L;
    private static Class<?> MAIN_CLASS;
    public Random random = new Random(1L);
    protected Client client;
    public Player[] player;
    private int id = -1;
    private String server = "localhost";
    private String gameName = "default";
    private String sessionName = "default";
    private int numPlayers = 1;
    private boolean audible = false;
    private boolean gameOver = false;
    private final ArrayList<GameLevel> levels = new ArrayList();
    private int levelIndex = -1;
    private GameLevel currentLevel;
    private boolean restarting = false;
    private boolean advancingToGameOver = false;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public GameLoop(Dimension dimension, Color color) {
        super(dimension, color);
        MAIN_CLASS = this.getClass();
    }

    public GameLoop() {
        this(new Dimension(400, 400));
    }

    public GameLoop(Dimension dimension) {
        super(dimension);
    }

    public void setParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    public String getParameter(String string) {
        try {
            if (this.parameters.containsKey(string)) {
                return this.parameters.get(string);
            }
            return super.getParameter(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static URL loadFromStackTrace(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement stackTraceElement = null;
        for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
            if (stackTraceElement2.getClassName().startsWith("fang")) continue;
            stackTraceElement = stackTraceElement2;
            break;
        }
        if (stackTraceElement == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            URL uRL = clazz.getResource(string);
            if (uRL == null) {
                uRL = clazz.getResource("resources/" + string);
            }
            return uRL;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static URL getGameResource(String string) {
        if (string.length() >= 7 && string.substring(0, 7).equals("http://")) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (MAIN_CLASS == null) {
            return GameLoop.loadFromStackTrace(string);
        }
        URL uRL = MAIN_CLASS.getResource(string);
        if (uRL == null) {
            uRL = MAIN_CLASS.getResource("resources/" + string);
        }
        if (uRL == null) {
            uRL = GameLoop.loadFromStackTrace(string);
        }
        return uRL;
    }

    public static void preloadGameResource(String ... stringArray) {
        for (String string : stringArray) {
            RawMediaCache.load(GameLoop.getGameResource(string));
        }
    }

    public void toggleSound() {
        super.toggleAudible();
        this.audible = !this.audible;
    }

    @Deprecated
    protected void toggleAudible() {
        this.toggleSound();
    }

    public boolean isMuted() {
        return !this.audible;
    }

    public void muteSound() {
        if (this.audible) {
            this.toggleSound();
        }
    }

    public void playSound() {
        if (!this.audible) {
            this.toggleSound();
        }
    }

    public void pause() {
        if (!this.isPaused()) {
            this.togglePause();
        }
    }

    public void resume() {
        if (this.isPaused()) {
            this.togglePause();
        }
    }

    public void startGameImmediately() {
        this.resume();
    }

    public void playSoundImmediately() {
        this.playSound();
    }

    private void callBeforeListening() {
        if (this.client.isConnected()) {
            this.numPlayers = this.client.keyboard.length;
            try {
                this.initializeCurrentGame();
                String string = this.getParameter("args");
                if (string != null) {
                    InitializeApplication.setParameter("UNAMED_ARGS", string);
                }
                for (String string2 : InitializeApplication.getArgumentNames()) {
                    ArrayList<String> arrayList = InitializeApplication.getNamedArgs(string2);
                    String string3 = arrayList.get(arrayList.size() - 1);
                    this.setParameter(string2, string3);
                }
                ArrayList<String> arrayList = InitializeApplication.getUnnamedArgs();
                if (arrayList != null && arrayList.size() > 0) {
                    String string2;
                    string2 = (String)arrayList.get(arrayList.size() - 1);
                    this.setParameter("args", string2);
                }
                this.startGame();
            }
            catch (Exception exception) {
                JTextArea jTextArea = new JTextArea();
                jTextArea.setText("Cannot Start Game!\n");
                jTextArea.append("Caused by Exception: " + exception.toString() + "\n");
                for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                    jTextArea.append("\t" + stackTraceElement + "\n");
                }
                this.getContentPane().removeAll();
                this.getContentPane().setLayout(new GridLayout(1, 1));
                this.getContentPane().add(new JScrollPane(jTextArea));
                this.getContentPane().validate();
                this.getContentPane().repaint();
                exception.printStackTrace();
                this.pause();
            }
            if (this.currentLevel == null) {
                this.currentLevel = this.getNextLevel();
                if (this.currentLevel != null) {
                    this.currentLevel.setGameLoop(this);
                    this.currentLevel.startLevel();
                }
            }
        } else {
            String string = "Cannot connect to " + this.server + "\n" + "Server unavailable or " + this.gameName + " full.";
            JOptionPane.showMessageDialog(null, string, "Cannot Connect!", 0);
            this.stop();
        }
    }

    public void begin() {
        if (this.client == null) {
            this.connect(this.server, this.getHash(), this.sessionName, this.numPlayers);
        }
    }

    public void startGame() {
    }

    public void advanceFrame(double d) {
    }

    public void postAdvanceFrame(double d) {
        if (!this.restarting && this.currentLevel != null) {
            this.currentLevel.advanceFrame(d);
            this.currentLevel.postAdvanceFrame();
        }
        for (Player player : this.player) {
            player.getMouse().clearClicks();
            player.getKeyboard().clear();
        }
        if (this.advancingToGameOver) {
            this.reallyGameOver();
            this.gameOver = true;
            this.advancingToGameOver = false;
        }
        if (this.restarting) {
            this.restarting = false;
            this.reallyStartOver();
        }
    }

    public void setServerName(String string) {
        this.server = string;
    }

    public void setSessionName(String string) {
        this.sessionName = string;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public String getServerName() {
        return this.server;
    }

    public void setGameName(String string) {
        this.gameName = string;
    }

    public String getGameName() {
        return this.gameName;
    }

    public void setNumberOfPlayers(int n) {
        this.numPlayers = n;
        this.setParameter("players", "" + n);
    }

    public int getNumberOfPlayers() {
        if (this.id < 0) {
            return -1;
        }
        return this.numPlayers;
    }

    public void sendMessage(Object object) {
        this.client.setLocalMessage(object);
    }

    public void connect(String string, String string2, String string3, int n) {
        int n2;
        Mouse mouse = new Mouse();
        Keyboard keyboard = new Keyboard();
        this.client = new Client(string, string2, string3, n, this);
        this.client.setLocalMouse(mouse);
        this.client.setLocalKeyboard(keyboard);
        this.client.setLocalMessage(null);
        this.id = this.client.getID();
        Keyboard[] keyboardArray = this.client.keyboard;
        Mouse[] mouseArray = this.client.mouse;
        Object[] objectArray = this.client.message;
        if (objectArray[0] != null && objectArray[0] instanceof Long) {
            this.random.setSeed((Long)objectArray[0]);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray[n2] = null;
        }
        this.player = new Player[keyboardArray.length];
        for (n2 = 0; n2 < this.player.length; ++n2) {
            this.player[n2] = new Player(keyboardArray[n2], mouseArray[n2], n2, objectArray);
        }
        this.callBeforeListening();
        this.client.connect();
        if (mouseArray.length > 1 && mouseArray[0] == mouseArray[1]) {
            System.err.println("Multiple players; same mouse?");
        }
    }

    public void stop() {
        super.stop();
        this.disconnect();
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    public boolean isPaused() {
        return this.client.isPaused();
    }

    public void togglePause() {
        this.pauseToggle();
    }

    protected void pauseToggle() {
        this.client.pauseToggle();
    }

    public void serverSaysPauseToggle() {
        super.pauseToggle();
    }

    public int getID() {
        if (this.id < 0) {
            System.err.println("Error: cannot get the player id until\nall players are connected and startGame\nis called.  Returning -1.");
        }
        return this.id;
    }

    public Player getPlayer(int n) {
        if (n < 0 || n >= this.player.length) {
            System.err.println("No such player.  There are only");
            System.err.println(this.player.length + " players with indexes [0, " + (this.player.length - 1) + "]");
            System.err.println("The requested index is " + n);
            return null;
        }
        return this.player[n];
    }

    public Player getPlayer(String string) {
        for (Player player : this.player) {
            if (!player.getName().equals(string)) continue;
            return player;
        }
        System.err.println("No such player with name: " + string + ".");
        System.err.println("Player names are: ");
        for (Player player : this.player) {
            System.err.print(player.getName() + "\t");
        }
        return null;
    }

    @Deprecated
    public URL getResource(String string) {
        URL uRL = this.getClass().getResource(string);
        return uRL;
    }

    public boolean gameIsOver() {
        return this.gameOver;
    }

    public void setGameOver(boolean bl) {
        if (!this.gameOver && bl) {
            this.advancingToGameOver = true;
        }
        this.gameOver = bl;
    }

    private void reallyGameOver() {
        if (this.currentLevel != null) {
            this.currentLevel.cleanUp();
            this.currentLevel.removeLevelObjects();
            if (!this.currentLevel.imagesCached()) {
                ImageSprite.clearCache();
            }
            if (!this.currentLevel.soundsCached()) {
                // empty if block
            }
            GameLevel gameLevel = this.currentLevel;
            GameLevel gameLevel2 = this.getGameOverLevel();
            if (gameLevel2 != null) {
                this.levelIndex = this.levels.size();
                this.currentLevel = gameLevel2;
                this.currentLevel.initializePersistantState(gameLevel.getPersistentAlarms(), gameLevel.getPersistentSprites(), gameLevel.getPersistentSounds());
                gameLevel.clearPersistence();
                this.currentLevel.setGameLoop(this);
                this.currentLevel.startLevel();
            }
        }
        this.gameOver = true;
    }

    public void addLevel(GameLevel gameLevel) {
        gameLevel.setGameLoop(this);
        this.levels.add(gameLevel);
        if (this.levels.size() == 1) {
            this.levelIndex = -1;
            this.advanceLevel();
        }
    }

    public void finishLevel() {
        if (this.currentLevel != null) {
            this.currentLevel.finishLevel();
        }
    }

    public void setNextLevel(GameLevel gameLevel) {
        boolean bl = false;
        if (this.levels.size() == 0) {
            bl = true;
        }
        this.levels.clear();
        gameLevel.setGameLoop(this);
        this.levels.add(gameLevel);
        this.levelIndex = -1;
        if (bl) {
            this.advanceLevel();
        }
    }

    public GameLevel getNextLevel() {
        if (this.levelIndex + 1 < this.levels.size()) {
            ++this.levelIndex;
            return this.levels.get(this.levelIndex);
        }
        return null;
    }

    public void advanceLevel() {
        GameLevel gameLevel = this.currentLevel;
        this.currentLevel = this.getNextLevel();
        if (this.currentLevel == null) {
            this.currentLevel = this.getGameOverLevel();
        }
        if (this.currentLevel != null) {
            if (gameLevel == null || !gameLevel.imagesCached()) {
                ImageSprite.clearCache();
            }
            if (gameLevel == null || !gameLevel.soundsCached()) {
                // empty if block
            }
            if (gameLevel != null) {
                this.currentLevel.initializePersistantState(gameLevel.getPersistentAlarms(), gameLevel.getPersistentSprites(), gameLevel.getPersistentSounds());
                gameLevel.clearPersistence();
            }
            if (this.client != null) {
                this.currentLevel.setGameLoop(this);
                this.currentLevel.startLevel();
            }
        } else {
            this.setGameOver(true);
        }
    }

    public int getLevelNumber() {
        return this.levelIndex;
    }

    public void startOver() {
        this.restarting = true;
    }

    private void reallyStartOver() {
        this.gameOver = false;
        this.restoreCursor();
        this.resetTime();
        ImageSprite.clearCache();
        this.canvas.removeAllSprites();
        this.cancelAllAlarms();
        this.client.clearInput();
        if (this.currentLevel != null) {
            this.currentLevel.clearPersistence();
            this.currentLevel.cleanUp();
        }
        this.levelIndex = -1;
        this.startGame();
        this.currentLevel = this.getNextLevel();
        if (this.currentLevel != null) {
            this.currentLevel.startLevel();
        }
    }

    public Player getPlayer() {
        return this.player[this.getID()];
    }

    public GameLevel getGameOverLevel() {
        return null;
    }

    public static void main(String[] stringArray) {
        InitializeApplication.fangMain(stringArray);
    }
}

