/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.core.Alarm;
import fang2.core.AnimationCanvas;
import fang2.core.GameLoop;
import fang2.core.Player;
import fang2.core.Sound;
import fang2.core.Sprite;
import java.net.URL;
import java.util.HashSet;
import java.util.Random;

public abstract class GameLevel {
    protected AnimationCanvas canvas;
    private GameLoop gameLoop;
    protected Random random;
    private HashSet<Alarm> persistentAlarms = new HashSet();
    private HashSet<Sprite> persistentSprites = new HashSet();
    private HashSet<Sound> persistentSounds = new HashSet();
    private boolean cacheImages = false;
    private boolean cacheSounds = false;
    private boolean finishingLevel = false;
    private boolean restartingLevel = false;

    public void setCacheImages(boolean bl) {
        this.cacheImages = bl;
    }

    public void setCacheSounds(boolean bl) {
        this.cacheSounds = bl;
    }

    public boolean imagesCached() {
        return this.cacheImages;
    }

    public boolean soundsCached() {
        return this.cacheSounds;
    }

    public void initializePersistantState(Alarm[] alarmArray, Sprite[] spriteArray, Sound[] soundArray) {
        for (Alarm object : alarmArray) {
            this.persistentAlarms.add(object);
        }
        for (Sprite sprite : spriteArray) {
            this.persistentSprites.add(sprite);
        }
        for (Sound sound : soundArray) {
            this.persistentSounds.add(sound);
        }
    }

    public void setGameLoop(GameLoop gameLoop) {
        this.gameLoop = gameLoop;
        this.canvas = this.gameLoop.canvas;
        this.random = this.gameLoop.random;
    }

    @Deprecated
    public void toggleAudible() {
        this.toggleSound();
    }

    public void toggleSound() {
        this.gameLoop.toggleSound();
    }

    public boolean isMuted() {
        return this.gameLoop.isMuted();
    }

    public void sendMessage(Object object) {
        this.gameLoop.sendMessage(object);
    }

    public boolean isPaused() {
        return this.gameLoop.isPaused();
    }

    public void pauseToggle() {
        this.gameLoop.pauseToggle();
    }

    public URL getResource(String string) {
        URL uRL = this.getClass().getResource(string);
        return uRL;
    }

    public abstract void startLevel();

    public abstract void advanceFrame(double var1);

    public void postAdvanceFrame() {
        if (this.restartingLevel) {
            this.reallyRestartLevel();
        }
        if (this.finishingLevel) {
            this.reallyFinishLevel();
        }
    }

    public void cleanUp() {
    }

    protected final void finishGame() {
        this.gameLoop.setGameOver(true);
    }

    protected void removeLevelObjects() {
        Sprite[] spriteArray = this.canvas.getAllSprites();
        Object[] objectArray = spriteArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Sprite sprite = objectArray[i];
            if (this.persistentSprites.contains(sprite)) continue;
            this.canvas.removeSprite(sprite);
        }
        for (Object object : objectArray = this.gameLoop.getAlarms()) {
            if (this.persistentAlarms.contains(object)) continue;
            this.gameLoop.cancelAlarm((Alarm)object);
        }
    }

    public void setNextLevel(GameLevel gameLevel) {
        this.gameLoop.setNextLevel(gameLevel);
    }

    public void finishLevel() {
        this.finishingLevel = true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private void reallyFinishLevel() {
        this.finishingLevel = false;
        this.cleanUp();
        this.removeLevelObjects();
        this.gameLoop.advanceLevel();
    }

    public void startOverLevel() {
        this.restartingLevel = true;
    }

    private void reallyRestartLevel() {
        this.restartingLevel = false;
        this.cleanUp();
        this.removeLevelObjects();
        this.startLevel();
    }

    public void persist(Alarm alarm) {
        this.persistentAlarms.add(alarm);
    }

    public void persist(Sprite sprite) {
        this.persistentSprites.add(sprite);
    }

    public void persist(Sound sound) {
        this.persistentSounds.add(sound);
    }

    public void clearPersistence(Alarm alarm) {
        this.persistentAlarms.remove(alarm);
    }

    public void clearPersistence(Sprite sprite) {
        this.persistentSprites.remove(sprite);
    }

    public void clearPersistence(Sound sound) {
        this.persistentSounds.remove(sound);
    }

    public void clearPersistence() {
        this.persistentAlarms.clear();
        this.persistentSprites.clear();
        this.persistentSounds.clear();
    }

    public Alarm[] getPersistentAlarms() {
        return this.persistentAlarms.toArray(new Alarm[0]);
    }

    public Sprite[] getPersistentSprites() {
        return this.persistentSprites.toArray(new Sprite[0]);
    }

    public Sound[] getPersistentSounds() {
        return this.persistentSounds.toArray(new Sound[0]);
    }

    public int getNumberOfPlayers() {
        return this.gameLoop.getNumberOfPlayers();
    }

    public int getID() {
        return this.gameLoop.getID();
    }

    protected final Player getPlayer(int n) {
        return this.gameLoop.getPlayer(n);
    }

    protected final Player getPlayer(String string) {
        return this.gameLoop.getPlayer(string);
    }

    public Player getPlayer() {
        return this.gameLoop.getPlayer();
    }

    public void scheduleRelative(Alarm alarm, double d) {
        this.gameLoop.scheduleRelative(alarm, d);
    }

    public void scheduleAbsolute(Alarm alarm, double d) {
        this.gameLoop.scheduleAbsolute(alarm, d);
    }

    public void cancelAlarm(Alarm alarm) {
        this.gameLoop.cancelAlarm(alarm);
    }

    public void cancelAllAlarms() {
        this.gameLoop.cancelAllAlarms();
    }

    public Alarm[] getAlarms() {
        return this.gameLoop.getAlarms();
    }

    public boolean isPeristent(Alarm alarm) {
        return this.persistentAlarms.contains(alarm);
    }

    public boolean isPeristent(Sprite sprite) {
        return this.persistentSprites.contains(sprite);
    }

    public boolean isPeristent(Sound sound) {
        return this.persistentSounds.contains(sound);
    }

    public void startOver() {
        this.gameLoop.startOver();
    }

    public void setHelp(String string) {
        this.gameLoop.setHelp(string);
    }

    public double getTime() {
        return this.gameLoop.getTime();
    }

    public void resetTime() {
        this.gameLoop.resetTime();
    }
}

